<?php

namespace BdevsElement\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;

defined('ABSPATH') || die();

class CF7 extends BDevs_El_Widget
{

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'cf7';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return __('Contact Form 7', 'bdevselement');
    }

    public function get_custom_help_url()
    {
        return 'http://elementor.bdevs.net//widgets/contact-7-form/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-shortcode';
    }

    public function get_keywords()
    {
        return ['form', 'contact', 'cf7', 'contact form', 'gravity', 'ninja'];
    }

    protected function register_content_controls()
    {
        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __('Design Style', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'bdevselement'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'bdevselement'),
                    'style_2' => __('Style 2', 'bdevselement'),
                    'style_3' => __('Style 3', 'bdevselement'),
                    'style_4' => __('Style 4', 'bdevselement'),
                    'style_5' => __('Style 5', 'bdevselement'),
                    'style_6' => __('Style 6', 'bdevselement'),
                    'style_7' => __('Style 7', 'bdevselement'),
                    'style_8' => __('Style 8', 'bdevselement'),
                    'style_9' => __('Style 9', 'bdevselement'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __('Title & Desccription', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 'Heading Sub Title',
                'placeholder' => __('Heading Sub Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1']
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bdevselement'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Heading Title',
                'placeholder' => __('Heading Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_4','style_6', 'style_9']
                ]
            ]
        );

        $this->add_control(
            'desccription',
            [
                'label' => __('Desccription', 'bdevselement'),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __('Heading Desccription Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_6']
                ]
            ]
        );
        $this->add_control(
            'total_dist',
            [
                'label' => __('Total Dist', 'bdevselement'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('Total Distance', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_2']
                ]
            ]
        );
        $this->add_control(
            'image_form',
            [
                'label' => __('Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_3', 'style_7', 'style_8']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __('H1', 'bdevselement'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => __('H2', 'bdevselement'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => __('H3', 'bdevselement'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => __('H4', 'bdevselement'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => __('H5', 'bdevselement'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => __('H6', 'bdevselement'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'bdevselement'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bdevselement'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'bdevselement'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            '_section_contact_icon',
            [
                'label' => __('Contact Icons', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_7', 'style_8', 'style_9']
                ]
            ]
        );

        $this->add_control(
            'icon_1',
            [
                'label' => __( 'Icon 1', 'bdevselement' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'design_style' => ['style_7', 'style_8', 'style_9']
                ]
            ]
        );
        $this->add_control(
            'icon_2',
            [
                'label' => __( 'Icon 2', 'bdevselement' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'design_style' => ['style_7', 'style_8']
                ]
            ]
        );
        $this->add_control(
            'icon_3',
            [
                'label' => __( 'Icon 3', 'bdevselement' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'design_style' => ['style_7', 'style_8']
                ]
            ]
        );
        $this->add_control(
            'icon_4',
            [
                'label' => __( 'Icon 4', 'bdevselement' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'design_style' => ['style_7', 'style_8']
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            '_section_features_list',
            [
                'label' => __('Contact List', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_55']
                ]
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'type',
            [
                'label' => __('Media Type', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon' => [
                        'title' => __('Icon', 'bdevselement'),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image' => [
                        'title' => __('Image', 'bdevselement'),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image'
                ]
            ]
        );

        if (bdevs_element_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'icon',
                [
                    'label' => __('Icon', 'bdevselement'),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'tab_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __('Title', 'bdevselement'),
                'default' => __('Title', 'bdevselement'),
                'placeholder' => __('Type title here', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'tab_content',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'show_label' => false,
                'placeholder' => __('Type content here', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(tab_title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            '_section_cf7',
            [
                'label' => bdevs_element_is_cf7_activated() ? __('Contact Form 7', 'bdevselement') : __('Missing Notice', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        if (!bdevs_element_is_cf7_activated()) {
            $this->add_control(
                '_cf7_missing_notice',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => sprintf(
                        __('Hello %2$s, looks like %1$s is missing in your site. Please click on the link below and install/activate %1$s. Make sure to refresh this page after installation or activation.', 'bdevselement'),
                        '<a href="' . esc_url(admin_url('plugin-install.php?s=Contact+Form+7&tab=search&type=term'))
                        . '" target="_blank" rel="noopener">Contact Form 7</a>',
                        bdevs_element_get_current_user_display_name()
                    ),
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-danger',
                ]
            );

            $this->add_control(
                '_cf7_install',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => '<a href="' . esc_url(admin_url('plugin-install.php?s=Contact+Form+7&tab=search&type=term')) . '" target="_blank" rel="noopener">Click to install or activate Contact Form 7</a>',
                ]
            );
            $this->end_controls_section();
            return;
        }

        $this->add_control(
            'form_id',
            [
                'label' => __('Select Your Form', 'bdevselement'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => ['' => __('', 'bdevselement')] + \bdevs_element_get_cf7_forms(),
            ]
        );

        $this->add_control(
            'html_class',
            [
                'label' => __('HTML Class', 'bdevselement'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => __('Add CSS custom class to the form.', 'bdevselement'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_map',
            [
                'label' => __('Map', 'elementor'),
            ]
        );

        $default_address = __('London Eye, London, United Kingdom', 'elementor');
        $this->add_control(
            'address',
            [
                'label' => __('Address', 'elementor'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => $default_address,
                'default' => $default_address,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'zoom',
            [
                'label' => __('Zoom Level', 'elementor'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 10,
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                    ],
                ],
            ]
        );


        $this->add_responsive_control(
            'height',
            [
                'label' => __('Height', 'elementor'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 300,
                ],
                'range' => [
                    'px' => [
                        'min' => 40,
                        'max' => 1440,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} iframe' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'prevent_scroll',
            [
                'label' => __('Prevent Scroll', 'elementor'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} iframe' => 'pointer-events: none;',
                ],
            ]
        );

        $this->add_control(
            'view',
            [
                'label' => __('View', 'elementor'),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'traditional',
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_controls()
    {
        $this->start_controls_section(
            '_section_fields_style',
            [
                'label' => __('Form Fields', 'bdevselement'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'field_width',
            [
                'label' => __('Width', 'bdevselement'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdevs-cf7-form label' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'field_margin',
            [
                'label' => __('Spacing Bottom', 'bdevselement'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'field_padding',
            [
                'label' => __('Padding', 'bdevselement'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'field_border_radius',
            [
                'label' => __('Border Radius', 'bdevselement'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hr',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'label' => __('Typography', 'bdevselement'),
                'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
                'scheme' => Typography::TYPOGRAPHY_3
            ]
        );

        $this->add_control(
            'field_color',
            [
                'label' => __('Text Color', 'bdevselement'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'field_placeholder_color',
            [
                'label' => __('Placeholder Text Color', 'bdevselement'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ::-webkit-input-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} ::-moz-placeholder' => 'color: {{VALUE}};',
                    '{{WRAPPER}} ::-ms-input-placeholder' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_field_state');

        $this->start_controls_tab(
            'tab_field_normal',
            [
                'label' => __('Normal', 'bdevselement'),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'field_border',
                'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'field_box_shadow',
                'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
            ]
        );

        $this->add_control(
            'field_bg_color',
            [
                'label' => __('Background Color', 'bdevselement'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_field_focus',
            [
                'label' => __('Focus', 'bdevselement'),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'field_focus_border',
                'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'field_focus_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
            ]
        );

        $this->add_control(
            'field_focus_bg_color',
            [
                'label' => __('Background Color', 'bdevselement'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'cf7-form-label',
            [
                'label' => __('Form Fields Label', 'bdevselement'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'label_margin',
            [
                'label' => __('Spacing Bottom', 'bdevselement'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hr3',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typography',
                'label' => __('Typography', 'bdevselement'),
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_3
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => __('Text Color', 'bdevselement'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();

        // Button 1 style
        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => __( 'Button', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'bdevselement' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'bdevselement' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bdevs-el-btn',
            ]
        );

        $this->add_control(
            'hrs',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => __( 'Normal', 'bdevselement' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'Background Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => __( 'Hover', 'bdevselement' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg_color',
            [
                'label' => __( 'Background Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

          $this->add_control(
            'button_hover_before_bg_color2',
            [
                'label' => __( 'Hover Before BG Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .shutter-btn::before, {{WRAPPER}} .shutter-btn:focus:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __( 'Border Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-btn:hover, {{WRAPPER}} .bdevs-el-btn:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (!bdevs_element_is_cf7_activated()) {
            return;
        }

        // button
        if (!empty($settings['button_link'])) {
            $this->add_inline_editing_attributes('button_text', 'none');
            $this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
            $this->add_render_attribute('button', 'class', 'bdevs-btn bt-btn bt-btn-sec');
            $this->add_link_attributes('button', $settings['button_link']);
        }

        $this->add_render_attribute('title', 'class', 'big_title mb-0');
        $this->add_render_attribute('title_1', 'class', 'big_title mb-0');
        $this->add_render_attribute('title_2', 'class', 'section-title');
        $title = bdevs_element_kses_basic($settings['title']);


        ?>
        <?php if ($settings['design_style'] === 'style_9'): ?>
         <!-- mewsletter area start  -->
        <div class="newsletter-area">
            <div class="container">
                <div class="row align-items-center wow fadeInUp2">
                    <div class="col-xl-7 col-lg-6">
                         <?php if ($settings['title']) : ?>
                        <div class="newsletter-text">
                            <h3><?php echo bdevs_element_kses_intermediate($settings['title']); ?></h3>
                        <?php endif; ?>
                        </div>
                        <?php if(!empty($settings['icon_1'])) : ?>
                        <div class="newsletter-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['icon_1'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-xl-5 col-lg-6">
                        <div class="newsletter-mail newsletter-mail-2">
                            <?php if (!empty($settings['form_id'])) {
                                echo bdevs_element_do_shortcode('contact-form-7', [
                                    'id' => $settings['form_id'],
                                    'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                                ]);
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- mewsletter area end -->
        <?php elseif ($settings['design_style'] === 'style_8'):
            $image_form = wp_get_attachment_image_url($settings['image_form']['id'], 'full');
            if (!$image_form) {
                $image_form = $settings['image_form']['url'];
            }
         ?>
         <!-- cta area start  -->
        <div class="cta__area-2 rb pt-120 pb-120 p-relative" data-background="<?php echo esc_url($image_form); ?>">
            <div class="container">
                <div class="cta__form wow fadeInUp2">
                    <?php if (!empty($settings['form_id'])) {
                            echo bdevs_element_do_shortcode('contact-form-7', [
                                'id' => $settings['form_id'],
                                'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                            ]);
                        }
                    ?>
                </div>
                <div class="icons-line mt-30 wow fadeInUp2">
                    <ul>
                         <?php if(!empty($settings['icon_1'])) : ?>
                        <li class="trp-icon">
                           <?php \Elementor\Icons_Manager::render_icon( $settings['icon_1'], [ 'aria-hidden' => 'true' ] ); ?>
                        </li>
                        <?php endif; ?>
                        <li class="h-rule">
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                        </li>
                         <?php if(!empty($settings['icon_2'])) : ?>
                        <li class="trp-icon">
                           <?php \Elementor\Icons_Manager::render_icon( $settings['icon_2'], [ 'aria-hidden' => 'true' ] ); ?>
                        </li>
                        <?php endif; ?>
                        <li class="h-rule">
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                        </li>
                         <?php if(!empty($settings['icon_3'])) : ?>
                        <li class="trp-icon">
                           <?php \Elementor\Icons_Manager::render_icon( $settings['icon_3'], [ 'aria-hidden' => 'true' ] ); ?>
                        </li>
                        <?php endif; ?>
                        <li class="h-rule">
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                            <i class="fas fa-horizontal-rule"></i>
                        </li>
                        <?php if(!empty($settings['icon_4'])) : ?>
                        <li class="trp-icon">
                           <?php \Elementor\Icons_Manager::render_icon( $settings['icon_4'], [ 'aria-hidden' => 'true' ] ); ?>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <!-- cta area end -->
        <?php elseif ($settings['design_style'] === 'style_7'):
            $image_form = wp_get_attachment_image_url($settings['image_form']['id'], 'full');
            if (!$image_form) {
                $image_form = $settings['image_form']['url'];
            }
         ?>
            <!-- cta area start  -->
        <div class="cta__area-2-1 p-relative">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <?php if (!empty($settings['form_id'])) {
                            echo bdevs_element_do_shortcode('contact-form-7', [
                                'id' => $settings['form_id'],
                                'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                            ]);
                        }
                        ?>
                        <div class="icons-line mt-30 wow fadeInUp2">
                            <ul>
                                <?php if(!empty($settings['icon_1'])) : ?>
                                <li class="trp-icon">
                                   <?php \Elementor\Icons_Manager::render_icon( $settings['icon_1'], [ 'aria-hidden' => 'true' ] ); ?>
                                </li>
                                <?php endif; ?>
                                <li class="h-rule">
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                </li>
                                 <?php if(!empty($settings['icon_2'])) : ?>
                                <li class="trp-icon">
                                   <?php \Elementor\Icons_Manager::render_icon( $settings['icon_2'], [ 'aria-hidden' => 'true' ] ); ?>
                                </li>
                                <?php endif; ?>
                                <li class="h-rule">
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                </li>
                                 <?php if(!empty($settings['icon_3'])) : ?>
                                <li class="trp-icon">
                                   <?php \Elementor\Icons_Manager::render_icon( $settings['icon_3'], [ 'aria-hidden' => 'true' ] ); ?>
                                </li>
                                <?php endif; ?>
                                <li class="h-rule">
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                    <i class="fal fa-horizontal-rule"></i>
                                </li>
                                 <?php if(!empty($settings['icon_4'])) : ?>
                                <li class="trp-icon">
                                   <?php \Elementor\Icons_Manager::render_icon( $settings['icon_4'], [ 'aria-hidden' => 'true' ] ); ?>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- cta area end -->
        <?php elseif ($settings['design_style'] === 'style_6'): ?>
            <div class="cta__box-inner p-relative" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/bg/cta-inner-bg.jpg">
                <div class="cta__box-form">
                    <?php if ($settings['title']) : ?>
                    <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_intermediate($settings['title']); ?></h4>
                        <?php endif; ?>
                        <?php if (!empty($settings['form_id'])) {
                            echo bdevs_element_do_shortcode('contact-form-7', [
                                'id' => $settings['form_id'],
                                'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                            ]);
                        }
                    ?>
                    <?php if ($settings['desccription']) : ?> 
                    <span class="bdevs-el-subtitle"><?php echo bdevs_element_kses_intermediate($settings['desccription']); ?></span>
                     <?php endif; ?>
                </div>
                <i class="pe-7s-mail-open-file "></i>
            </div>
        <?php elseif ($settings['design_style'] === 'style_5'): ?>
            <div class="widget-form">
                <?php if (!empty($settings['form_id'])) {
                    echo bdevs_element_do_shortcode('contact-form-7', [
                        'id' => $settings['form_id'],
                        'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                    ]);
                }
                ?>
            </div>
        <?php elseif ($settings['design_style'] === 'style_4'): ?>
            <div class="sd-form">
                <?php if ($settings['title']) : ?>
                    <h4><?php echo bdevs_element_kses_intermediate($settings['title']); ?></h4>
                <?php endif; ?>
                <?php if (!empty($settings['form_id'])) {
                    echo bdevs_element_do_shortcode('contact-form-7', [
                        'id' => $settings['form_id'],
                        'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                    ]);
                }
                ?>
            </div>

        <?php elseif ($settings['design_style'] === 'style_3'):
        // bg_image
        $image_form = wp_get_attachment_image_url($settings['image_form']['id'], 'full');
        if (!$image_form) {
            $image_form = $settings['image_form']['url'];
        }
        ?>

        <div class="order__form-details">
            <div class="container p-0">
                <div class="row g-5">
                    <div class="col-xl-4">
                        <?php if(!empty($image_form)) : ?>
                        <div class="track-img">
                            <img src="<?php echo esc_url($image_form); ?>" alt="img">
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-xl-8">
                        <?php if (!empty($settings['form_id'])) {
                            echo bdevs_element_do_shortcode('contact-form-7', [
                                'id' => $settings['form_id'],
                                'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                            ]);
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

    <?php elseif ($settings['design_style'] === 'style_2'):
        $col_count = $settings['total_dist'] ? 'col-xl-8' : 'col-12';
        ?>
        <div class="order__form-details">
            <div class="container p-0">
                <div class="row g-5">
                    <?php if(!empty($settings['total_dist'])) : ?>
                    <div class="col-xl-4">
                        <div class="order__counter">
                            <div class="order__counter-chart">
                                <div class="circlechart" data-percentage="75">
                                    <svg class="circle-chart"
                                        viewBox="0 0 33.83098862 33.83098862"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle class="circle-chart__background"
                                            cx="16.9" cy="16.9" r="15.9"></circle>
                                        <circle
                                            class="circle-chart__circle warning-stroke"
                                            stroke-dasharray="30,100" cx="16.9"
                                            cy="16.9" r="15.9">
                                        </circle>
                                    </svg>
                                </div>
                                <div class="circle-chart-text">
                                    <h3 class="miles"><?php echo esc_html($settings['total_dist']); ?><span><?php echo esc_attr__('km', 'volport'); ?></span></h3>
                                    <span><?php echo esc_attr__('Dist (Miles)', 'volport'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="<?php echo esc_attr($col_count); ?>">
                        <?php if (!empty($settings['form_id'])) {
                            echo bdevs_element_do_shortcode('contact-form-7', [
                                'id' => $settings['form_id'],
                                'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                            ]);
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

    <?php else:
        if (empty($settings['address'])) {
            return;
        }

        if (0 === absint($settings['zoom']['size'])) {
            $settings['zoom']['size'] = 10;
        }
        ?>
         <!-- contact form area  -->
        <div class="contact-form">
            <div class="contact-form-inner">
                <div class="container">
                    <div class="row wow fadeInUp2">
                        <?php if(!empty($settings['sub_title'] && $settings['title'])) : ?>
                        <div class="col-xl-12">
                            <div class="section-title text-center mb-60">
                                <?php if(!empty($settings['sub_title'])) : ?>
                                <span class="<?php echo esc_attr__('category', 'volport'); ?>"><?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?></span>
                                <?php endif; ?>
                                <?php if ($settings['title']) : ?>
                                <h2><?php echo bdevs_element_kses_intermediate($settings['title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="col-xl-12">
                            <div class="sd-form tmd-form">
                                 <?php
                                    if (!empty($settings['form_id'])) {
                                        echo bdevs_element_do_shortcode('contact-form-7', [
                                            'id' => $settings['form_id'],
                                            'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
                                        ]);
                                    }
                                    ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- contact form end -->
    <?php endif; ?>


        <?php

    }
}
