<?php
namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Group_Control_Text_Shadow;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;



defined( 'ABSPATH' ) || die();

class Coverage extends BDevs_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'coverage';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Coverage Map', 'bdevselement' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.bdevs.net//widgets/icon-box/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-preview-medium';
    }

    public function get_keywords() {
        return [ 'coverage', 'map', 'icon' ];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevselement' )
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        // Background Overlay
        $this->start_controls_section(
            '_section_background_overlay',
            [
                'label' => __( 'Background Overlay', 'elementor' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_10'],
                ], 
            ]
        );
        
        $this->start_controls_tabs( 'tabs_background_overlay' );

        $this->start_controls_tab(
            'tab_background_overlay_normal',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __( 'Background', 'bdevselement' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .elementor-background-overlay',
            ]
        );

        $this->add_control(
            'background_overlay_opacity',
            [
                'label' => __( 'Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => .5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .elementor-background-overlay' => 'opacity: {{SIZE}};',
                ],
                // 'condition' => [
                //     'background_overlay_background' => [ 'classic', 'gradient' ],
                // ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_background_overlay_hover',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_hover',
                'label' => __( 'Background', 'bdevselement' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .zf-item:hover .elementor-background-overlay',
            ]
        );

        $this->add_control(
            'background_hover_overlay_opacity',
            [
                'label' => __( 'Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => .5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .zf-item:hover .elementor-background-overlay' => 'opacity: {{SIZE}};',
                ],
                // 'condition' => [
                //     'background_overlay_background' => [ 'classic', 'gradient' ],
                // ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        // overlay end

        // Section Image
       $this->start_controls_section(
            '_section_image',
            [
                'label' => __('Image', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_10'],
                ],
            ]
        );

        $this->add_control(
            'featured_big_image',
            [
                'label' => __('BG Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();


        // Title & Description
         $this->start_controls_section(
            '_section_title',
            [
                'label' => __('Title & Description', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 'Heading Sub Title',
                'placeholder' => __('Heading Sub Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 4,
                'default' => 'Heading Title',
                'placeholder' => __('Heading Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'back_title',
            [
                'label' => __('Back Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'rows' => 4,
                'default' => 'Coverage',
                'placeholder' => __('Back Title Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', 'bdevselement'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Description text goes here', 'bdevselement'),
                'placeholder' => __('Heading Description Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __('H1', 'bdevselement'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => __('H2', 'bdevselement'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => __('H3', 'bdevselement'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => __('H4', 'bdevselement'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => __('H5', 'bdevselement'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => __('H6', 'bdevselement'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'bdevselement'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bdevselement'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'bdevselement'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_about_image',
            [
                'label' => __('Image', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'map_image',
            [
                'label' => __('Map Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail2',
                'default' => 'large',
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_cover_country',
            [
                'label' => __( 'Country List', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
            'country_name',
            [
                'label' => __( 'Country name', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Europe', 'bdevselement' ),
                'placeholder' => __( 'Type country name', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'countries',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_cover_list',
            [
                'label' => __( 'Cover List', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'field_condition',
            [
                'label' => __( 'Field condition', 'bdevselement' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'phone', 'bdevselement' ),
                    'style_2' => __( 'email', 'bdevselement' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );  

        $repeater->add_control(
            'type',
            [
                'label' => __( 'Media Type', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'bdevselement' ),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'bdevselement' ),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,

            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image'
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'bdevselement' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        } 
        else {
            $repeater->add_control(
                'selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'type2',
            [
                'label' => __( 'Media Type', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon2' => [
                        'title' => __( 'Icon', 'bdevselement' ),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image2' => [
                        'title' => __( 'Image', 'bdevselement' ),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon2',
                'toggle' => false,
                'style_transfer' => true,

            ]
        );

        $repeater->add_control(
            'image2',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type2' => 'image2'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail2',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type2' => 'image2'
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'icon2',
                [
                    'label' => __( 'Icon', 'bdevselement' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type2' => 'icon2'
                    ]
                ]
            );
        } 
        else {
            $repeater->add_control(
                'selected_icon2',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type2' => 'icon2'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'cover_image',
            [
                'label' => __( 'Cover Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'cover_phone',
            [
                'label' => __( 'Phone Number', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '897 987 908 95', 'bdevselement' ),
                'placeholder' => __( 'Type Phone Number', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'cover_email',
            [
                'label' => __( 'Email Account', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'info@webmail.com', 'bdevselement' ),
                'placeholder' => __( 'Type Email', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'phone_url',
            [
                'label' => __( 'Phone URL', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '89798790895', 'bdevselement' ),
                'placeholder' => __( 'Phone Url', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'email_url',
            [
                'label' => __( 'Email URL', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'info@webmail.com', 'bdevselement' ),
                'placeholder' => __( 'Email Url', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ]
            ]
        );

        $this->add_responsive_control(
            'align_slide',
            [
                'label' => __( 'Alignment', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevselement' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevselement' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevselement' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bdevselement' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content',
                'exclude' => [
                    'image'
                ]
            ]
        );
        
        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );
        
        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );
        
        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .bdevs-el-content p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        // Back Title
        $this->add_control(
            '_back_title_content',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Back Title', 'bdevselement' ),
                'separator' => 'before'
            ]
        );

         $this->add_control(
            '_backtitle_color',
            [
                'label' => __( 'Back Title Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-backtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'backtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-backtitle',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );
        
        
        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend.
     *
     * Used to generate the final HTML displayed on the frontend.
     *
     * Note that if skin is selected, it will be rendered by the skin itself,
     * not the widget.
     *
     * @since 1.0.0
     * @access public
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        $this->add_inline_editing_attributes( 'description', 'none' );
        $this->add_render_attribute( 'description', 'class', 'content-desc' );

        ?>

        <?php if ( $settings['design_style'] === 'style_2' ): 

        $this->add_inline_editing_attributes( 'title', 'basic' );
        $this->add_render_attribute( 'title', 'class', 'section-title-2' );

        $title = bdevs_element_kses_basic($settings['title']);

        ?>

        <section class="features__area">
            <div class="container">
                <div class="row align-items-center wow fadeInUp2">
                    <div class="col-xl-6 col-lg-6">
                        <div class="special-features mb-30">
                            <ul>
                             <?php 
                                foreach ( $settings['slides'] as $key => $slide ):
                                    if (!empty($slide['image']['id'])) {
                                        $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                        if ( ! $image ) {
                                            $image = $slide['image']['url'];
                                        }
                                }
                               ?>
                                <li>
                                    <div class="features__icon">
                                        <?php if( !empty($slide['selected_icon']) ): ?>
                                        <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                        <?php else: ?>
                                        <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr('icon', 'bdevselement'); ?>" />
                                        <?php endif; ?>
                                    </div>
                                    <div class="features__about">
                                        <?php if( $slide['title'] ) : ?>
                                        <h4 class="bdevs-el-title">
                                          <?php echo bdevs_element_kses_basic( $slide['title'] ); ?>
                                        </h4>
                                        <?php endif; ?>
                                        
                                        <?php if( $slide['description'] ) : ?>
                                        <p class="bdevs-el-content">
                                          <?php echo bdevs_element_kses_basic( $slide['description'] ); ?>
                                        </p>
                                        <?php endif; ?> 
                                    </div>
                                </li>
                            <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6">
                        <div class="features__content mb-30">
                            <div class="section-title-wrapper mb-35">
                                <?php if ($settings['sub_title']) : ?>
                                <span class="section-pre-title bdevs-el-sub">
                                  <?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
                               </span>
                                <?php endif; ?>
                                   <?php printf('<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape($settings['title_tag']),
                                    $this->get_render_attribute_string('title'),
                                    $title
                                ); ?>
                            </div>
                            <?php if ($settings['description']) : ?>
                              <p class="bdevs-el-content"><?php echo bdevs_element_kses_intermediate($settings['description']); ?> </p>
                            <?php endif; ?>

                            <div class="support p-relative">
                                <div class="support__icon">
                                    <i class="pe-7s-headphones"></i>
                                </div>
                                <div class="support__about">
                                    <?php if ($settings['features_support']) : ?>
                                    <p><?php echo bdevs_element_kses_intermediate($settings['features_support']); ?></p>
                                    <?php endif; ?>
                                     
                                    <?php if ($settings['features_phone']) : ?> 
                                     <span><a href="tel:89787676587"><?php echo bdevs_element_kses_intermediate($settings['features_phone']); ?></a></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php elseif ( $settings['design_style'] === 'style_3' ):

         $title = bdevs_element_kses_basic($settings['title']);

        if ( !empty($settings['featured_signature']['id']) ) {
            $featured_signature = wp_get_attachment_image_url( $settings['featured_signature']['id'], $settings['thumbnail_size'] );
        } 

        if ( !empty($settings['featured_author_image']['id']) ) {
            $featured_author_image = wp_get_attachment_image_url( $settings['featured_author_image']['id'], $settings['thumbnail_size'] );
        } 

        if ( !empty($settings['featured_big_image']['id']) ) {
            $featured_big_image = wp_get_attachment_image_url( $settings['featured_big_image']['id'], $settings['thumbnail_size'] );
        }  

        ?>  
        
        <section class="features__area-display">
            <div class="container">
                <div class="row align-items-center wow fadeInUp2">
                    <div class="col-lg-6">
                        <div class="features__content mb-30">
                           <?php printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                $title
                           ); ?>
                             <?php if ($settings['description']) : ?>
                              <p class="bdevs-el-content"><?php echo bdevs_element_kses_intermediate($settings['description']); ?> </p>
                            <?php endif; ?>


                            <div class="features__author d-sm-flex">
                                <div class="features__author-signature mr-30">
                                    <?php if ($settings['featured_signature']) : ?>
                                    <img src="<?php echo esc_url($featured_signature); ?>" alt="img">
                                    <?php endif; ?>
                                </div>
                                <div class="features__author-content d-flex align-items-center">
                                    <div class="features__author-img mr-20">
                                        <?php if ($settings['featured_author_image']) : ?>
                                        <img src="<?php echo esc_url($featured_author_image); ?>" alt="img">
                                        <?php endif; ?>
                                    </div>
                                    <div class="features__author-text">
                                        <?php if ($settings['features_title']) : ?>
                                        <h4>
                                            <?php echo bdevs_element_kses_intermediate($settings['features_title']); ?>
                                        </h4>
                                        <?php endif; ?>

                                        <?php if ($settings['features_designation']) : ?>
                                        <span><?php echo bdevs_element_kses_intermediate($settings['features_designation']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="features__right p-relative mb-30">
                            <div class="features__right-img">
                                <img src="<?php echo esc_url($featured_big_image); ?>" alt="logistics image">
                            </div>
                            <ul class="features__right-content">
                                   <?php 
                                      foreach ( $settings['slides'] as $key => $slide ):
                                        if (!empty($slide['image']['id'])) {
                                            $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                            if ( ! $image ) {
                                                $image = $slide['image']['url'];
                                            }
                                        }
                                    ?>
                                <li>
                                <?php if( !empty($slide['selected_icon']) ): ?>
                                    <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                    <?php else: ?>
                                    <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr('icon', 'bdevselement'); ?>" />
                                    <?php endif; ?>

                                    <?php if( $slide['title'] ) : ?>
                                    <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['title'] ); ?></h4>
                                    <?php endif; ?>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section> 


        <?php else: 

        if (!empty($settings['map_image']['id'])) {
            $map_image = wp_get_attachment_image_url($settings['map_image']['id'], 'full');
        }
        ?>

        <section class="coverage__area coverage_extrapt-1">
            <div class="container">
                <div class="row wow fadeInUp2">
                    <div class="col-xl-7 col-lg-7">
                        <div class="section-title">
                            <?php if(!empty($settings['sub_title'])) : ?>
                            <span class="bdevs-el-subtitle"><i class="fal fa-ship"></i><?php echo esc_html($settings['sub_title']); ?></span>
                            <?php endif; ?>
                            <?php if(!empty($settings['title'])) : ?>
                            <h2 class="mb-20 bdevs-el-title"><?php echo esc_html($settings['title']); ?></h2>
                            <?php endif; ?>
                            <?php if(!empty($settings['back_title'])) : ?>
                            <div class="back-text d-none d-xl-block extra_back1">
                                <span class="bdevs-el-backtitle"><?php echo esc_html($settings['back_title']); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php if(!empty($settings['description'])) : ?>
                        <div class="coverage__text bdevs-el-content">
                            <p><?php echo esc_html($settings['description']); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-xl-5 col-lg-5">
                        <div class="coverage__division">
                            <div>
                                <ul>
                                    <?php 
                                    $c_i = 0;
                                    foreach ( $settings['countries'] as $key => $country ): 
                                    $c_i++;
                                    ?>
                                    <li><a class="cont-<?php echo esc_attr($c_i); ?>" href="javascript:void()"><?php echo esc_html($country['country_name']); ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="coverage__map p-relative wow fadeInUp2">
                    <img src="<?php echo esc_url($map_image); ?>" alt="<?php echo esc_attr('map-image', 'bdevselement'); ?>">
                    <div class="dot-main">
                        <?php 
                        $c_i = 0;
                        foreach ( $settings['slides'] as $key => $slide ):
                            $c_i++;
                            $_active = $c_i == 1 ? 'active' : '';
                            if (!empty($slide['image']['id'])) {
                                $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                if ( ! $image ) {
                                    $image = $slide['image']['url'];
                                }
                        }
                        if(!empty($slide['cover_image']['id'])) {
                            $cover_image = wp_get_attachment_image_url( $slide['cover_image']['id'], $settings['thumbnail_size'] );
                        }
                       ?>
                        <div class="dot-main-item">
                            <div class="dot dot-<?php echo esc_attr($c_i); ?> <?php echo esc_attr($_active); ?>">
                                <div class="dot-content p-relative">
                                    <div class="dot-inner">
                                        <?php if(!empty($slide['cover_image'])) : ?>
                                        <img src="<?php echo esc_url($cover_image); ?>" alt="<?php echo esc_attr('cover-image', 'bdevselement'); ?>">
                                        <?php endif; ?>
                                        <ul class="dot-contact">
                                            <li>
                                                <?php if( !empty($slide['selected_icon']) ): ?>
                                                <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                                <?php else: ?>
                                                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr('icon', 'bdevselement'); ?>" />
                                                <?php endif; ?>
                                                <span><a href="tel:<?php echo esc_url($slide['phone_url']); ?>"><?php echo esc_html($slide['cover_phone']); ?></a></span>
                                            </li>
                                            <li>
                                                <?php if( !empty($slide['selected_icon2']) ): ?>
                                                <?php bdevs_element_render_icon( $slide, 'icon2', 'selected_icon2', ['class' => 'bdevs-btn-icon'] ); ?>
                                                <?php else: ?>
                                                <img src="<?php echo esc_url($image2); ?>" alt="<?php echo esc_attr('icon', 'bdevselement'); ?>" />
                                                <?php endif; ?>
                                                <span><a href="mailto:<?php echo esc_url($slide['email_url']); ?>"><?php echo esc_url($slide['cover_email']); ?></a></span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>

                    </div>
                </div>
            </div>
        </section>

        <?php endif; ?>
        
        <?php
    }

}
