<?php
namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Group_Control_Text_Shadow;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;



defined( 'ABSPATH' ) || die();

class Featured_List extends BDevs_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'featured_list';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Featured List', 'bdevselement' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.bdevs.net//widgets/icon-box/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-preview-medium';
    }

    public function get_keywords() {
        return [ 'featured', 'list', 'icon' ];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevselement' ),
                    'style_2' => __( 'Style 2', 'bdevselement' ),
                    'style_3' => __( 'Style 3', 'bdevselement' ),
                    'style_4' => __( 'Style 4', 'bdevselement' ),
                    'style_5' => __( 'Style 5', 'bdevselement' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        // Background Overlay
        $this->start_controls_section(
            '_section_background_overlay',
            [
                'label' => __( 'Background Overlay', 'elementor' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1'],
                ], 
            ]
        );
        
        $this->start_controls_tabs( 'tabs_background_overlay' );

        $this->start_controls_tab(
            'tab_background_overlay_normal',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __( 'Background', 'bdevselement' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .elementor-background-overlay',
            ]
        );

        $this->add_control(
            'background_overlay_opacity',
            [
                'label' => __( 'Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => .5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .elementor-background-overlay' => 'opacity: {{SIZE}};',
                ],
                // 'condition' => [
                //     'background_overlay_background' => [ 'classic', 'gradient' ],
                // ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_background_overlay_hover',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_hover',
                'label' => __( 'Background', 'bdevselement' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .zf-item:hover .elementor-background-overlay',
            ]
        );

        $this->add_control(
            'background_hover_overlay_opacity',
            [
                'label' => __( 'Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => .5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .zf-item:hover .elementor-background-overlay' => 'opacity: {{SIZE}};',
                ],
                // 'condition' => [
                //     'background_overlay_background' => [ 'classic', 'gradient' ],
                // ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        // overlay end

        // Section Image
       $this->start_controls_section(
            '_section_image',
            [
                'label' => __('Image', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1','style_3'],
                ],
            ]
        );

        $this->add_control(
            'featured_big_image',
            [
                'label' => __('BG Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();


        // Title & Description
         $this->start_controls_section(
            '_section_title',
            [
                'label' => __('Title & Description', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 'Heading Sub Title',
                'placeholder' => __('Heading Sub Text', 'bdevselement'),
                'condition' => [
                    'design_style' => ['style_1','style_2']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 4,
                'default' => 'Heading Title',
                'placeholder' => __('Heading Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $this->add_control(
            'title_count',
            [
                'label' => __('Title Count', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 4,
                'default' => 'Heading Title Count',
                'placeholder' => __('Heading Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_5']
                ],
            ]
        );


        $this->add_control(
            'description',
            [
                'label' => __('Description', 'bdevselement'),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __('Heading Description Text', 'bdevselement'),
                'condition' => [
                    'design_style' => ['style_2','style_3', 'style_4']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __('H1', 'bdevselement'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => __('H2', 'bdevselement'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => __('H3', 'bdevselement'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => __('H4', 'bdevselement'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => __('H5', 'bdevselement'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => __('H6', 'bdevselement'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );


           $this->add_control(
            'title_tag2',
            [
                'label' => __('Title HTML Tag', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __('H1', 'bdevselement'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => __('H2', 'bdevselement'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => __('H3', 'bdevselement'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => __('H4', 'bdevselement'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => __('H5', 'bdevselement'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => __('H6', 'bdevselement'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h4',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'bdevselement'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bdevselement'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'bdevselement'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        // Features author
         $this->start_controls_section(
            '_features_author',
            [
                'label' => __('Features Author', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_3'
                ],
            ]
        );

        $this->add_control(
            'features_title',
            [
                'label' => __('Features Title', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 4,
                'default' => 'Features Author Title',
                'placeholder' => __('Features Author Title', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'features_designation',
            [
                'label' => __('Features Designation', 'bdevselement'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Features Designation Here',
                'placeholder' => __('Features Designation Here', 'bdevselement'),
                'condition' => [
                    'design_style' => ['style_2','style_3']
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'featured_signature',
            [
                'label' => __('Signature Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'featured_author_image',
            [
                'label' => __('Author Image', 'bdevselement'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );


        $this->end_controls_section();


        // Features Info
         $this->start_controls_section(
            '_features_info',
            [
                'label' => __('Features Info', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_2'
                ],
            ]
        );

        $this->add_control(
            'features_support',
            [
                'label' => __('Features Support', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 'Features Support',
                'placeholder' => __('Features Support Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'features_phone',
            [
                'label' => __('Features Phone Number', 'bdevselement'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 4,
                'default' => 'Features Phone Number',
                'placeholder' => __('Features Phone Number', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            '_section_icon',
            [
                'label' => __( 'Featured List', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'field_condition',
            [
                'label' => __( 'Field condition', 'bdevselement' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevselement' ),
                    'style_2' => __( 'Style 2', 'bdevselement' ),
                    'style_3' => __( 'Style 3', 'bdevselement' ),
                    'style_4' => __( 'Style 4', 'bdevselement' ),
                    'style_5' => __( 'Style 5', 'bdevselement' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'f_icon_bg_color',
            [
                'label' => __( 'BG Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FEC931',
                'frontend_available' => true,
                'selectors' => [
                     '{{WRAPPER}}  {{CURRENT_ITEM}}' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'field_condition' => ['style_10'],
                ],
                'style_transfer' => true,
                'frontend_available' => true,
            ]
        );  

        $repeater->add_control(
            'type',
            [
                'label' => __( 'Media Type', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'bdevselement' ),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'bdevselement' ),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image'
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'bdevselement' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        } 
        else {
            $repeater->add_control(
                'selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'bg_image',
            [
                'label' => __( 'BG Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'field_condition' => ['style_10'],
                ], 
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Features Title', 'bdevselement' ),
                'placeholder' => __( 'Type Icon Box Title', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                        'field_condition' => ['style_1', 'style_2', 'style_3', 'style_5']
                ]
            ]
        );

        $repeater->add_control(
            'f_url',
            [
                'label' => __( 'URL', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '#', 'bdevselement' ),
                'placeholder' => __( 'Url here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );


        $repeater->add_control(
            'description',
            [
                'label' => __( 'Description', 'bdevselement' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => __( 'Icon Description', 'bdevselement' ),
                'condition' => [
                    'field_condition' => ['style_1', 'style_5'],
                ], 
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'featured_key',
            [
                'label' => __( 'Featured Label', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Button Text',
                'placeholder' => __( 'Type button text here', 'bdevselement' ),
                'label_block' => true,
                'condition' => [
                    'field_condition' => ['style_4'],
                ], 
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'featured_value',
            [
                'label' => __( 'Featured Label', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Button Text',
                'placeholder' => __( 'Type button text here', 'bdevselement' ),
                'label_block' => true,
                'condition' => [
                    'field_condition' => ['style_4'],
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );


        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'button_icon',
                [
                    'label' => __( 'Icon', 'bdevselement' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-angle-right',
                    'condition' => [
                        'field_condition' => ['style_10'],
                    ], 
                ]
            );

            $condition = ['button_icon!' => ''];
        } else {
            $repeater->add_control(
                'button_selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'button_icon',
                    'label_block' => true,
                    'condition' => [
                        'field_condition' => ['style_10'],
                    ], 
                ]
            );
            $condition = ['button_selected_icon[value]!' => ''];
        }

        $repeater->add_control(
            'button_icon_position',
            [
                'label' => __( 'Icon Position', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'before' => [
                        'title' => __( 'Before', 'bdevselement' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'after' => [
                        'title' => __( 'After', 'bdevselement' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'before',
                'toggle' => false,
                'condition' => $condition,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'button_icon_spacing',
            [
                'label' => __( 'Icon Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => $condition,
                'condition' => [
                    'field_condition' => ['style_10'],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdevs-btn--icon-before .bdevs-btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdevs-btn--icon-after .bdevs-btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ]
            ]
        );

        $this->add_responsive_control(
            'align_slide',
            [
                'label' => __( 'Alignment', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevselement' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevselement' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevselement' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bdevselement' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .bdevs-el-content',
                'exclude' => [
                    'image'
                ]
            ]
        );
        
        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2,
            ]
        );
        
        // Subtitle    
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        // Subtitle    
        $this->add_control(
            '_heading_slidetitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'List Title', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'slidetitle_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-slidetitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'slidetitle_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-slidetitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'slidetitle',
                'selector' => '{{WRAPPER}} .bdevs-el-slidetitle',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        
        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bdevselement' ),
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .bdevs-el-content p',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );
        
        
        $this->end_controls_section();


        $this->start_controls_section(
            '_section_style_content_info',
            [
                'label' => __( 'Info Contact', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                 'condition' => [
                    'design_style' => ['style_2']
                ]
            ]
        );

         $this->add_control(
            'content_info',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-info' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'contactinfo',
                'selector' => '{{WRAPPER}} .bdevs-el-info',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->end_controls_section();

                $this->start_controls_section(
            '_section_style_author_content',
            [
                'label' => __( 'Author Contact', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                 'condition' => [
                    'design_style' => ['style_3']
                ]
            ]
        );

         $this->add_control(
            '_author_content_title',
            [
                'label' => __( 'Title Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-author_title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'author',
                'selector' => '{{WRAPPER}} .bdevs-el-author_title',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );


         $this->add_control(
            '_author_content_subtitle',
            [
                'label' => __( 'Subtitle Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-author-sub' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'author-subtitle',
                'selector' => '{{WRAPPER}} .bdevs-el-author-sub',
                'scheme' => Typography::TYPOGRAPHY_4,
            ]
        );

        $this->end_controls_section();


    }

    /**
     * Render widget output on the frontend.
     *
     * Used to generate the final HTML displayed on the frontend.
     *
     * Note that if skin is selected, it will be rendered by the skin itself,
     * not the widget.
     *
     * @since 1.0.0
     * @access public
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        $this->add_inline_editing_attributes( 'description', 'none' );
        $this->add_render_attribute( 'description', 'class', 'content-desc' );

        ?>

        <?php if ( $settings['design_style'] === 'style_2' ):

        $this->add_inline_editing_attributes( 'title', 'basic' );
        $this->add_render_attribute( 'title', 'class', 'section-title-2 bdevs-el-title' );

        $title = bdevs_element_kses_basic($settings['title']);

        ?>

        <section class="features__areaa features_extra-pt-1">
            <div class="container">
                <div class="row align-items-center wow fadeInUp2">
                    <div class="col-xl-6 col-lg-6">
                        <div class="special-features mb-30">
                            <ul>
                             <?php 
                                foreach ( $settings['slides'] as $key => $slide ):
                                    if (!empty($slide['image']['id'])) {
                                        $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                        if ( ! $image ) {
                                            $image = $slide['image']['url'];
                                        }
                                }
                               ?>
                                <li>
                                    <div class="features__icon">
                                        <?php if( !empty($slide['selected_icon']) ): ?>
                                        <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                        <?php else: ?>
                                        <img src="<?php echo esc_url($image); ?>" alt="icon" />
                                        <?php endif; ?>
                                    </div>
                                    <div class="features__about">
                                        <?php if( $slide['title'] ) : ?>
                                        <h4 class="bdevs-el-slidetitle">
                                          <?php echo bdevs_element_kses_basic( $slide['title'] ); ?>
                                        </h4>
                                        <?php endif; ?>
                                        
                                        <?php if( $slide['description'] ) : ?>
                                        <p class="bdevs-el-subtitle">
                                          <?php echo bdevs_element_kses_basic( $slide['description'] ); ?>
                                        </p>
                                        <?php endif; ?> 
                                    </div>
                                </li>
                            <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6">
                        <div class="features__content bdevs-el-content mb-30">
                            <div class="section-title-wrapper mb-35">
                                <?php if ($settings['sub_title']) : ?>
                                <span class="section-pre-title bdevs-el-subtitle">
                                  <?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
                               </span>
                                <?php endif; ?>
                                   <?php printf('<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape($settings['title_tag']),
                                    $this->get_render_attribute_string('title'),
                                    $title
                                ); ?>
                            </div>
                            <?php if ($settings['description']) : ?>
                              <p class="bdevs-el-content"><?php echo bdevs_element_kses_intermediate($settings['description']); ?> </p>
                            <?php endif; ?>

                            <div class="support p-relative">
                                <div class="support__icon">
                                    <i class="pe-7s-headphones"></i>
                                </div>
                                <div class="support__about">
                                    <?php if ($settings['features_support']) : ?>
                                    <p><?php echo bdevs_element_kses_intermediate($settings['features_support']); ?></p>
                                    <?php endif; ?>
                                     
                                    <?php if ($settings['features_phone']) : ?> 
                                     <span class="bdevs-el-info"><a href="tel:89787676587"><?php echo bdevs_element_kses_intermediate($settings['features_phone']); ?></a></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php elseif ( $settings['design_style'] === 'style_3' ):

         $title = bdevs_element_kses_basic($settings['title']);

          $this->add_inline_editing_attributes( 'title', 'basic' );
          $this->add_render_attribute( 'title', 'class', 'features__content bdevs-el-title' );

        if ( !empty($settings['featured_signature']['id']) ) {
            $featured_signature = wp_get_attachment_image_url( $settings['featured_signature']['id'], $settings['thumbnail_size'] );
        } 

        if ( !empty($settings['featured_author_image']['id']) ) {
            $featured_author_image = wp_get_attachment_image_url( $settings['featured_author_image']['id'], $settings['thumbnail_size'] );
        } 

        if ( !empty($settings['featured_big_image']['id']) ) {
            $featured_big_image = wp_get_attachment_image_url( $settings['featured_big_image']['id'], $settings['thumbnail_size'] );
        }  

        ?>  
        
        <section class="features__area-display features_extrat-2">
            <div class="container">
                <div class="row align-items-center wow fadeInUp2">
                    <div class="col-lg-6">
                        <div class="features__content mb-30 bdevs-el-content">
                           <?php printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                $title
                           ); ?>
                             <?php if ($settings['description']) : ?>
                              <p class=""><?php echo bdevs_element_kses_intermediate($settings['description']); ?> </p>
                            <?php endif; ?>


                            <div class="features__author d-sm-flex">
                                <div class="features__author-signature mr-30">
                                    <?php if ($settings['featured_signature']) : ?>
                                    <img src="<?php echo esc_url($featured_signature); ?>" alt="img">
                                    <?php endif; ?>
                                </div>
                                <div class="features__author-content d-flex align-items-center">
                                    <div class="features__author-img mr-20">
                                        <?php if ($settings['featured_author_image']) : ?>
                                        <img src="<?php echo esc_url($featured_author_image); ?>" alt="img">
                                        <?php endif; ?>
                                    </div>
                                    <div class="features__author-text">
                                        <?php if ($settings['features_title']) : ?>
                                        <h4 class="bdevs-el-author_title">
                                            <?php echo bdevs_element_kses_intermediate($settings['features_title']); ?>
                                        </h4>
                                        <?php endif; ?>

                                        <?php if ($settings['features_designation']) : ?>
                                        <span class="bdevs-el-author-sub"><?php echo bdevs_element_kses_intermediate($settings['features_designation']);?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="features__right p-relative mb-30">
                            <div class="features__right-img">
                                <img src="<?php echo esc_url($featured_big_image); ?>" alt="logistics image">
                            </div>
                            <ul class="features__right-content">
                                   <?php 
                                      foreach ( $settings['slides'] as $key => $slide ):
                                        if (!empty($slide['image']['id'])) {
                                            $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                            if ( ! $image ) {
                                                $image = $slide['image']['url'];
                                            }
                                        }
                                    ?>
                                <li>
                                <?php if( !empty($slide['selected_icon']) ): ?>
                                    <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                    <?php else: ?>
                                    <img src="<?php echo esc_url($image); ?>" alt="icon" />
                                    <?php endif; ?>

                                    <?php if( $slide['description'] ) : ?>
                                    <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['description'] ); ?></h4>
                                    <?php endif; ?>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php elseif ( $settings['design_style'] === 'style_4' ):
            $this->add_inline_editing_attributes( 'title', 'basic' );
            $this->add_render_attribute( 'title', 'class', 'mb-20 bdevs-el-title' );
            $title = bdevs_element_kses_basic($settings['title']);
            ?>
            <div class="work-time p-relative">
                <img src="https://www.devsnews.com/wp/volport/wp-content/themes/volport/assets/img/icon/clock.png" alt="img">
                <div class="work-meta bdevs-el-content">
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag2']),
                        $this->get_render_attribute_string('title'),
                        $title
                    ); ?>
                    <?php if(!empty($settings['description'])) : ?>
                      <p><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                    <?php if(!empty( $settings['slides'])) : ?>
                    <ul>
                        <?php foreach ( $settings['slides'] as $key => $slide ) : ?>
                        <?php if(!empty($slide['featured_key'])) : ?>
                        <li><span><?php echo bdevs_element_kses_intermediate($slide['featured_key']); ?></span> <?php echo bdevs_element_kses_intermediate($slide['featured_value']); ?></li>
                        <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
                </div>
            </div>
        <?php elseif ( $settings['design_style'] === 'style_5' ):
            $this->add_inline_editing_attributes( 'title', 'basic' );
            $this->add_render_attribute( 'title', 'class', 'mb-20' );
            $title = bdevs_element_kses_basic($settings['title']);
            ?>
            <div class="member-qualification pl-5">
                <?php if(!empty($settings['title'])) : ?>
                <h4><span><?php echo $settings['title_count'] ? $settings['title_count'] : ''; ?>.</span> <?php echo bdevs_element_kses_basic($settings['title']); ?></h4>
                <?php endif; ?>
                <div class="member-education mt-40">
                    <?php if(!empty($settings['slides'])) : ?>
                    <ul>
                    <?php
                    foreach ( $settings['slides'] as $key => $slide ):
                        if (!empty($slide['image']['id'])) {
                            $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                            if ( ! $image ) {
                                $image = $slide['image']['url'];
                            }
                        }
                        ?>
                        <li>
                            <div class="edu-icon">
                                <?php if( !empty($slide['selected_icon']) ): ?>
                                    <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                <?php else: ?>
                                    <img src="<?php echo esc_url($image); ?>" alt="icon" />
                                <?php endif; ?>
                            </div>
                            <div class="edu-text bdevs-el-content">
                                <?php if( $slide['title'] ) : ?>
                                <h5 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['title'] ); ?></h5>
                                <?php endif; ?>
                                <?php if( $slide['description'] ) : ?>
                                        <p><?php echo bdevs_element_kses_basic( $slide['description'] ); ?></p>
                                <?php endif; ?>
                            </div>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
        <?php else:

        $this->add_inline_editing_attributes( 'title', 'basic' );
        $this->add_render_attribute( 'title', 'class', 'mb-20 bdevs-el-title' );

        $title = bdevs_element_kses_basic($settings['title']);

        $this->add_render_attribute( 'button', 'class', 'text_btn' );

        if ( !empty($settings['featured_big_image']['id']) ) {
            $featured_big_image = wp_get_attachment_image_url( $settings['featured_big_image']['id'], $settings['thumbnail_size'] );
        }

        ?>


        <div class="sector-coveragee p-relative">
            <div class="sector-coverage-img d-none d-lg-block wow fadeInLeft2">
                <?php if ($settings['featured_big_image']) : ?>
                <img src="<?php echo esc_url($featured_big_image); ?>" alt="logistics image">
                <?php endif; ?>
            </div>
            <div class="container">
                <div class="row justify-content-end wow fadeInRight2">
                    <div class="col-xl-6 col-lg-7">
                        <div class="sector-coverage-content pt-120 pb-90">
                            <div class="section-title white">
                                <?php if ($settings['sub_title']) : ?>
                                <span class="bdevs-el-subtitle"><i class="fal fa-ship"></i>
                                    <?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
                                </span>
                                <?php endif; ?>
                                <?php printf('<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape($settings['title_tag']),
                                    $this->get_render_attribute_string('title'),
                                    $title
                                ); ?>
                            </div>
                            <ul class="sector-coverage-items bdevs-el-content">
                               <?php 
                                foreach ( $settings['slides'] as $key => $slide ):
                                    if (!empty($slide['image']['id'])) {
                                        $image = wp_get_attachment_image_url( $slide['image']['id'], $settings['thumbnail_size'] );
                                        if ( ! $image ) {
                                            $image = $slide['image']['url'];
                                        }
                                }
                               ?>
                                <li class="mb-30">
                                    <div class="sector-coverage-icon">
                                    <?php if( !empty($slide['selected_icon']) ): ?>
                                    <?php bdevs_element_render_icon( $slide, 'icon', 'selected_icon', ['class' => 'bdevs-btn-icon'] ); ?>
                                    <?php else: ?>
                                    <img src="<?php echo esc_url($image); ?>" alt="icon" />
                                    <?php endif; ?>
                                    </div>
                                    <div class="sector-coverage-text">
                                    <?php if( $slide['title'] ) : ?>
                                    <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['title'] ); ?></h4>
                                    <?php endif; ?>
                                    <?php if( $slide['description'] ) : ?>
                                    <p class="bdevs-el-content"><?php echo bdevs_element_kses_basic( $slide['description'] ); ?></p>
                                    <?php endif; ?> 
                                       
                                    </div>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php endif; ?>
        
        <?php
    }

}
