<?php

namespace BdevsElement\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Icons_Manager;
use \Elementor\Repeater;
use \Elementor\Core\Schemes;
use \Elementor\Group_Control_Background;
Use \Elementor\Core\Schemes\Typography;
use \BdevsElement\BDevs_El_Select2;

defined('ABSPATH') || die();


class Post_List extends BDevs_El_Widget
{

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'post_list';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return __('Post List', 'bdevselement');
    }

    public function get_custom_help_url()
    {
        return 'http://elementor.bdevs.net/widgets/post-list/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-parallax';
    }

    public function get_keywords()
    {
        return ['posts', 'post', 'post-list', 'list', 'news'];
    }

    /**
     * Get a list of All Post Types
     *
     * @return array
     */
    public function get_post_types()
    {
        $post_types = bdevs_element_get_post_types([], ['elementor_library', 'attachment']);
        return $post_types;
    }

    protected function register_content_controls()
    {


        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __('Design Style', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'bdevselement'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'bdevselement'),
                    'style_2' => __('Style 2', 'bdevselement'),
                    'style_3' => __('Style 3', 'bdevselement'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_post_list',
            [
                'label' => __('List', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'post_type',
            [
                'label' => __('Source', 'bdevselement'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_post_types(),
                'default' => key($this->get_post_types()),
            ]
        );

        $this->add_control(
            'show_post_by',
            [
                'label' => __('Show post by:', 'bdevselement'),
                'type' => Controls_Manager::SELECT,
                'default' => 'recent',
                'options' => [
                    'recent' => __('Recent Post', 'bdevselement'),
                    'selected' => __('Selected Post', 'bdevselement'),
                ],

            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item Limit', 'bdevselement'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'dynamic' => ['active' => true],
                'condition' => [
                    'show_post_by' => ['recent']
                ]
            ]
        );

        $repeater = [];

        foreach ($this->get_post_types() as $key => $value) {

            $repeater[$key] = new Repeater();

            $repeater[$key]->add_control(
                'title',
                [
                    'label' => __('Title', 'bdevselement'),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __('Customize Title', 'bdevselement'),
                    'dynamic' => [
                        'active' => true,
                    ],
                ]
            );

            $repeater[$key]->add_control(
                'post_id',
                [
                    'label' => __('Select ', 'bdevselement') . $value,
                    'label_block' => true,
                    'type' => BDevs_El_Select2::TYPE,
                    'multiple' => false,
                    'placeholder' => 'Search ' . $value,
                    'data_options' => [
                        'post_type' => $key,
                        'action' => 'bdevs_element_post_list_query'
                    ],
                ]
            );

            $this->add_control(
                'selected_list_' . $key,
                [
                    'label' => '',
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater[$key]->get_controls(),
                    'title_field' => '{{ title }}',
                    'condition' => [
                        'show_post_by' => 'selected',
                        'post_type' => $key
                    ],
                ]
            );
        }

        $this->end_controls_section();

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __('Settings', 'bdevselement'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'feature_image',
            [
                'label' => __('Featured Image', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'post_image',
                'default' => 'thumbnail',
                'exclude' => [
                    'custom'
                ],
                'condition' => [
                    'feature_image' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'list_icon',
            [
                'label' => __('List Icon', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'feature_image!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'bdevselement'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'far fa-check-circle',
                    'library' => 'reguler'
                ],
                'condition' => [
                    'list_icon' => 'yes',
                    'feature_image!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'meta',
            [
                'label' => __('Show Meta', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'author_meta',
            [
                'label' => __('Author', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'meta' => 'yes',
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'author_icon',
            [
                'label' => __('Author Icon', 'bdevselement'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'far fa-user',
                    'library' => 'reguler',
                ],
                'condition' => [
                    'meta' => 'yes',
                    'author_meta' => 'yes',
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'date_meta',
            [
                'label' => __('Date', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'meta' => 'yes',
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'date_icon',
            [
                'label' => __('Date Icon', 'bdevselement'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'far fa-calendar-check',
                    'library' => 'reguler',
                ],
                'condition' => [
                    'meta' => 'yes',
                    'date_meta' => 'yes',
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'category_meta',
            [
                'label' => __('Category', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'meta' => 'yes',
                    'post_type' => 'post',
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'category_icon',
            [
                'label' => __('Category Icon', 'bdevselement'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'far fa-folder-open',
                    'library' => 'reguler',
                ],
                'condition' => [
                    'meta' => 'yes',
                    'category_meta' => 'yes',
                    'post_type' => 'post',
                    'design_style' => ['style_1', 'style_2', 'style_3']
                ]
            ]
        );

        $this->add_control(
            'meta_position',
            [
                'label' => __('Meta Position', 'bdevselement'),
                'type' => Controls_Manager::SELECT,
                'default' => 'bottom',
                'options' => [
                    'top' => __('Top', 'bdevselement'),
                    'bottom' => __('Bottom', 'bdevselement'),
                ],
                'condition' => [
                    'meta' => 'yes',
                    'design_style' => ['style_10']
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __('H1', 'bdevselement'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => __('H2', 'bdevselement'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => __('H3', 'bdevselement'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => __('H4', 'bdevselement'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => __('H5', 'bdevselement'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => __('H6', 'bdevselement'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h3',
                'toggle' => false,
            ]
        );

        $this->add_control(
            'item_align',
            [
                'label' => __('Alignment', 'bdevselement'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'bdevselement'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bdevselement'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'bdevselement'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors_dictionary' => [
                    'left' => 'justify-content: flex-start',
                    'center' => 'justify-content: center',
                    'right' => 'justify-content: flex-end',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdevselement-post-list .bdevselement-post-list-item a' => '{{VALUE}};'
                ],
                'condition' => [
                    'view' => 'list',
                ]
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => __('Content', 'bdevselement'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bdevselement'),
                'label_off' => __('Hide', 'bdevselement'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'content_limit',
            [
                'label' => __('Content Limit', 'bdevselement'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '14',
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'content' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'post_btn_text',
            [
                'label' => __('BTN Text', 'bdevselement'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Read More', 'bdevselement'),
                'placeholder' => __('Link Text', 'bdevselement'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_controls()
    {
        // post_list_style
        $this->start_controls_section(
            '_section_post_list_style',
            [
                'label' => __('List', 'bdevselement'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'list_item_common',
                [
                    'label' => __('Common', 'bdevselement'),
                    'type' => Controls_Manager::HEADING,
                ]
            );

            $this->add_responsive_control(
                'list_item_margin',
                [
                    'label' => __('Margin', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_responsive_control(
                'list_item_padding',
                [
                    'label' => __('Padding', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'list_item_background',
                    'label' => __('Background', 'bdevselement'),
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .bdevselement-post-list-item',
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'list_item_box_shadow',
                    'label' => __('Box Shadow', 'bdevselement'),
                    'selector' => '{{WRAPPER}} .bdevselement-post-list-item',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'list_item_border',
                    'label' => __('Border', 'bdevselement'),
                    'selector' => '{{WRAPPER}} .bdevselement-post-list-item',
                ]
            );

            $this->add_responsive_control(
                'list_item_border_radius',
                [
                    'label' => __('Border Radius', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );

        $this->end_controls_section();

        // title
        $this->start_controls_section(
            '_section_style_title',
            [
                'label' => __( 'Title', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
                'scheme' => Typography::TYPOGRAPHY_2
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .bdevs-el-title',
            ]
        );

        $this->start_controls_tabs( '_tabs_title' );

        $this->start_controls_tab(
            '_tab_title_normal',
            [
                'label' => __( 'Normal', 'bdevselement' ),
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_title_hover',
            [
                'label' => __( 'Hover', 'bdevselement' ),
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}:hover .bdevs-el-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // description
        $this->start_controls_section(
            '_section_style_desc',
            [
                'label' => __( 'Description', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'desc_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-des' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __( 'Text Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdevs-el-des' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => __( 'Typography', 'bdevselement' ),
                'selector' => '{{WRAPPER}} .bdevs-el-des',
                'scheme' => Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();

        //List Meta Style
        $this->start_controls_section(
            '_section_list_meta_style',
            [
                'label' => __('Meta', 'bdevselement'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'meta' => 'yes',
                ]
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_typography',
                    'label' => __('Typography', 'bdevselement'),
                    'scheme' => Schemes\Typography::TYPOGRAPHY_3,
                    'selector' => '{{WRAPPER}} .bdevselement-post-list-meta-wrap span a',
                ]
            );

            $this->add_control(
                'meta_color',
                [
                    'label' => __('Color', 'bdevselement'),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-meta-wrap span a' => 'color: {{VALUE}};',
                    ],
                ]
            );


            $this->add_responsive_control(
                'meta_space',
                [
                    'label' => __('Meta Space', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-meta-wrap span a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_responsive_control(
                'meta_icon_heading',
                [
                    'label' => __('Meta Icon', 'bdevselement'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'meta_icon_color',
                [
                    'label' => __('Color', 'bdevselement'),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-meta-wrap span a i' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'meta_icon_space',
                [
                    'label' => __('Space Between', 'bdevselement'),
                    'type' => Controls_Manager::SLIDER,
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-list-meta-wrap span a i' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        //List Date Style
        $this->start_controls_section(
            '_section_list_date_style',
            [
                'label' => __('Date', 'bdevselement'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'date_space',
                [
                    'label' => __('Date Space', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_date_typography',
                    'label' => __('Typography', 'bdevselement'),
                    'scheme' => Schemes\Typography::TYPOGRAPHY_3,
                    'selector' => '{{WRAPPER}} .bdevselement-post-date',
                ]
            );

            $this->add_control(
                'meta_date_color',
                [
                    'label' => __('Color', 'bdevselement'),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .bdevselement-post-date' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

        $this->end_controls_section();

        // Button style
        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => __( 'Button', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'button_padding',
                [
                    'label' => __( 'Padding', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .bdevs-btn',
                    'scheme' => Typography::TYPOGRAPHY_4,
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'button_border',
                    'selector' => '{{WRAPPER}} .bdevs-btn',
                ]
            );

            $this->add_control(
                'button_border_radius',
                [
                    'label' => __( 'Border Radius', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'button_box_shadow',
                    'selector' => '{{WRAPPER}} .bdevs-btn',
                ]
            );

            $this->add_control(
                'hr',
                [
                    'type' => Controls_Manager::DIVIDER,
                    'style' => 'thick',
                ]
            );

            $this->start_controls_tabs( '_tabs_button' );

            $this->start_controls_tab(
                '_tab_button_normal',
                [
                    'label' => __( 'Normal', 'bdevselement' ),
                ]
            );

            $this->add_control(
                'button_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'button_bg_color',
                [
                    'label' => __( 'Background Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                '_tab_service_button_hover',
                [
                    'label' => __( 'Hover', 'bdevselement' ),
                ]
            );

            $this->add_control(
                'button_hover_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn:hover, {{WRAPPER}} .bdevs-btn:focus' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'button_hover_bg_color',
                [
                    'label' => __( 'Background Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn:hover, {{WRAPPER}} .bdevs-btn:focus' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'button_hover_border_color',
                [
                    'label' => __( 'Border Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'condition' => [
                        'button_border_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-btn:hover, {{WRAPPER}} .bdevs-btn:focus' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();
            $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        if (!$settings['post_type']) return;
        $args = [
            'post_status' => 'publish',
            'post_type' => $settings['post_type'],
        ];
        if ('recent' === $settings['show_post_by']) {
            $args['posts_per_page'] = $settings['posts_per_page'];
        }

        $selected_post_type = 'selected_list_' . $settings['post_type'];

        $customize_title = [];
        $ids = [];
        if ('selected' === $settings['show_post_by']) {
            $args['posts_per_page'] = -1;
            $lists = $settings['selected_list_' . $settings['post_type']];
            if (!empty($lists)) {
                foreach ($lists as $index => $value) {
                    $post_id = !empty($value['post_id']) ? $value['post_id'] : 0;
                    $ids[] = $post_id;
                    if ($value['title']) $customize_title[$post_id] = $value['title'];
                }
            }
            $args['post__in'] = (array)$ids;
            $args['orderby'] = 'post__in';
        }

        if ('selected' === $settings['show_post_by'] && empty($ids)) {
            $posts = [];
        } else {
            $posts = get_posts($args);
        }

        ?>

        <?php if (!empty($settings['design_style']) and $settings['design_style'] == 'style_2'): 
            $this->add_render_attribute('title', 'class', 'blog__title-2 bdevs-el-title');
        ?>
        <?php foreach ($posts as $inx => $post) : ?>
        <div class="blog__item-2 transition-3 mb-30">
        <?php if ('yes' === $settings['feature_image']): ?>
            <div class="blog__thumb-2 w-img">
                <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>">
                    <img src="<?php print get_the_post_thumbnail_url($post->ID, 'full'); ?>" alt="<?php _e('img', 'volport'); ?>">
                </a>
            </div>
        <?php endif; ?>
            <div class="blog__content-2 bdevselement-post-list-item">
            <?php if ('post' === $settings['post_type'] && 'yes' === $settings['category_meta']):
            $categories = get_the_category($post->ID); ?>
                <div class="blog__tag-2 bdevselement-post-list-meta-wrap">
                    <span>
                    <a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>">
                        <?php if ($settings['category_icon']):
                            Icons_Manager::render_icon($settings['category_icon'], ['aria-hidden' => 'true']);
                        endif;
                        echo esc_html($categories[0]->name); ?>
                    </a>
                    </span>
                </div>
                <?php endif; ?>
                <?php if ('yes' === $settings['author_meta']): ?>
                <div class="blog__author d-flex align-items-center bdevselement-post-list-meta-wrap">
                    <?php if(!empty(get_avatar(get_the_author_meta('ID')))) : ?>
                    <div class="blog__author-img mr-10">
                        <?php echo get_avatar(get_the_author_meta('ID')); ?>
                    </div>
                    <?php endif; ?>
                    <div class="blog__author-content">
                        <span><?php _e('By','volport'); ?> <a href="<?php print esc_url(get_author_posts_url(get_the_author_meta($post->ID))); ?>"><?php echo esc_html( get_the_author_meta( 'display_name', $post->post_author ) ); ?></a></span>
                    </div>
                </div>
                <?php endif; ?>
                <?php $title = $post->post_title;
                if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                    $title = $customize_title[$post->ID];
                }
                printf('<%1$s %2$s><a href="%4$s">%3$s</a></%1$s>',
                    tag_escape($settings['title_tag']),
                    $this->get_render_attribute_string('title'),
                    esc_html($title),
                    esc_url(get_the_permalink($post->ID))
                ); ?>
                <div class="blog__meta-2 d-flex align-items-center justify-content-between">
                    <?php if ('yes' === $settings['date_meta']): ?>
                    <div class="blog__meta-left ">
                        <span class="bdevselement-post-date">
                            <?php if ( $settings['date_icon'] ):
                                Icons_Manager::render_icon( $settings['date_icon'], [ 'aria-hidden' => 'true' ] );
                            endif;
                            echo get_the_date( "M d, Y",$post->ID );
                            ?>
                        </span>
                    </div>
                    <?php endif; ?>
                    <div class="blog__meta-right bdevselement-post-list-meta-wrap">
                        <span><a href="<?php echo get_comments_link($post->ID); ?>"><i class="fal fa-comments"></i> <?php echo !empty(wp_count_comments($post->ID)) ? wp_count_comments($post->ID)->approved : 0; ?></a></span>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>

        <?php elseif (!empty($settings['design_style']) and $settings['design_style'] == 'style_3'): 
            $this->add_render_attribute('title', 'class', 'bdevs-el-title');
        ?>
         
        <?php foreach ($posts as $inx => $post):?>

        <div class="news__post p-relative mb-30">
            <?php if ('yes' === $settings['date_meta']): ?>
            <div class="news__date">
                <span>
                    <?php ?>
                    <span><?php echo get_the_date( "d",$post->ID ); ?></span>
                    <?php echo get_the_date( "M",$post->ID ); ?>
                </span>
            </div>
            <?php endif; ?>
        <?php if ('yes' === $settings['feature_image']): ?>
            <div class="news__thumb">
                <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>"><img src="<?php print get_the_post_thumbnail_url($post->ID, 'full'); ?>" alt="<?php _e('img', 'volport'); ?>"></a>
            </div>
        <?php endif; ?>
            <div class="news__content p-relative bdevselement-post-list-item bdevselement-post-list-meta-wrap">
            <?php if ('yes' === $settings['author_meta']): ?>
                <span><?php _e('By', 'volport'); ?> <a href="<?php print esc_url(get_author_posts_url(get_the_author_meta($post->ID))); ?>"><?php echo esc_html( get_the_author_meta( 'display_name', $post->post_author ) ); ?></a></span>
            <?php endif; ?>
                <?php $title = $post->post_title;
                if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                    $title = $customize_title[$post->ID];
                }
                printf('<%1$s %2$s><a href="%4$s">%3$s</a></%1$s>',
                    tag_escape($settings['title_tag']),
                    $this->get_render_attribute_string('title'),
                    esc_html($title),
                    esc_url(get_the_permalink($post->ID))
                ); ?>
            <?php if ('post' === $settings['post_type'] && 'yes' === $settings['category_meta']):
            $categories = get_the_category($post->ID); ?>
                <div class="transport bdevselement-post-list-meta-wrap">
                    <span>
                        <?php if ($settings['category_icon']):
                            Icons_Manager::render_icon($settings['category_icon'], ['aria-hidden' => 'true']);
                        endif;
                        echo esc_html($categories[0]->name); ?>
                    </span>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <?php endforeach; wp_reset_query(); ?>
        <?php else:
            $this->add_render_attribute('title', 'class', 'n_title bdevs-el-title');
            if (!empty($posts)): ?>

            <?php foreach ($posts as $inx => $post):?>
                <div class="blog__post mb-30">
                    <div class="blog__img p-relative">
                        <?php if ('yes' === $settings['feature_image']): ?>
                        <div class="blog__thumb">
                            <a href="<?php echo esc_url(get_the_permalink($post->ID)); ?>"><img src="<?php print get_the_post_thumbnail_url($post->ID, 'full'); ?>" alt="img"></a>
                        </div>
                        <?php endif; ?>
                        <?php if ('yes' === $settings['date_meta']): ?>
                        <div class="blog__date bdevselement-post-date">
                            <p class="bdevselement-post-date"><span><?php echo get_the_date( "d", $post->ID); ?></span><?php echo get_the_date( "M", $post->ID); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="blog__content bdevselement-post-list-item bdevselement-post-list-meta-wrap">
                        <?php if ('post' === $settings['post_type'] && 'yes' === $settings['category_meta']):
                            $categories = get_the_category($post->ID); ?>
                            <span><a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>" class="nsub_title">
                                <?php if ($settings['category_icon']):
                                    Icons_Manager::render_icon($settings['category_icon'], ['aria-hidden' => 'true']);
                                endif;
                                echo esc_html($categories[0]->name); ?>
                            </a></span>
                        <?php endif; ?>
                        <?php $title = $post->post_title;
                        if ('selected' === $settings['show_post_by'] && array_key_exists($post->ID, $customize_title)) {
                            $title = $customize_title[$post->ID];
                        }
                        printf('<%1$s %2$s><a href="%4$s">%3$s</a></%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            esc_html($title),
                            esc_url(get_the_permalink($post->ID))
                        ); ?>

                        <?php if (!empty($settings['content'])):
                            $content_limit = (!empty($settings['content_limit'])) ? $settings['content_limit'] : '';
                            ?>
                            <p class="bdevs-el-des">
                                <?php print wp_trim_words(get_the_excerpt($post->ID), $content_limit, ''); ?>
                            </p>
                        <?php endif; ?>

                        <?php if (!empty($settings['post_btn_text'])): ?>
                        <a class="bdevs-btn" href="<?php echo get_the_permalink($post->ID); ?>"><?php echo $settings['post_btn_text']; ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; wp_reset_query(); ?>


            <?php
            else:
                printf('%1$s %2$s %3$s',
                    __('No ', 'bdevselement'),
                    esc_html($settings['post_type']),
                    __('Found', 'bdevselement')
                );
            endif;
            ?>
        <?php endif;
    }
}
