<?php 
/** 
 * The main template file
 *
 * @package  WordPress
 * @subpackage  medidove
 */
get_header(); ?>


        <div class="project__details pt-120 pb-90">
            <div class="container">
                <?php 
                    if( have_posts() ):
                    while( have_posts() ): the_post();
                        $case_details_image = function_exists('get_field') ? get_field('case_details_image') : '';
                        $case_social = function_exists('get_field') ? get_field('case_social') : '';
                        $department_info_list = function_exists('get_field') ? get_field('department_info_list') : '';
                ?> 

                <div class="row">
                    <div class="col-lg-12">
                        <div class="pdm-img p-relative mb-50">
                            <?php if(!empty($case_details_image)): ?>
                            <img src="<?php echo esc_url($case_details_image['url']); ?>" alt="">
                            <?php endif; ?> 
                            <div class="project__meta d-none d-sm-block">
                                <div class="project__client">
                                    <ul>
                                        <?php if (!empty($department_info_list['case_customer_text'])) : ?>
                                        <li>
                                            <h6><?php echo wp_kses_post( $department_info_list['case_customer_label'] ); ?></h6>
                                            <span><?php echo wp_kses_post( $department_info_list['case_customer_text'] ); ?></span>
                                        </li>
                                        <?php endif; ?>

                                        <?php if (!empty($department_info_list['case_date'])) : ?>
                                        <li>
                                            <h6><?php echo wp_kses_post( $department_info_list['case_date_label'] ); ?></h6>
                                            <span><?php echo wp_kses_post( $department_info_list['case_date'] ); ?></span>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                    <ul class="second">
                                        <?php if (!empty($department_info_list['case_website'])) : ?>
                                        <li>
                                            <h6><?php echo wp_kses_post( $department_info_list['case_website_label'] ); ?></h6>
                                            <span><?php echo wp_kses_post( $department_info_list['case_website'] ); ?></span>
                                        </li>
                                        <?php endif; ?>

                                        <?php if (!empty($department_info_list['case_cat_label'])) : ?>
                                        <li>
                                            <h6><?php echo wp_kses_post( $department_info_list['case_cat_label'] ); ?></h6>
                                            <span><?php echo wp_kses_post( $department_info_list['case_cat'] ); ?></span>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>

                                <?php echo wp_kses_post( $case_social ); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-8">
                        <div class="service-details-content">
                            <h4><?php the_title(); ?></h4>

                            <?php the_content(); ?>
                        </div>
                    </div>
                    <?php if ( is_active_sidebar( 'portfolio-sidebar' ) ) : ?>
                    <div class="col-xl-4">
                        <div class="service-details-sidebar">
                            <?php do_action("volport_portfolio_sidebar"); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php 
                endwhile; wp_reset_query();
                endif; 
                ?>
            </div>
        </div>



<?php get_footer();  ?>