(function ($) {
	"use strict";


	$(window).on('load',function() {
		$("#loading").fadeOut(500);
	});

	// meanmenu
	$("#mobile-menu").meanmenu({
		meanMenuContainer: ".mobile-menu",
		meanScreenWidth: "991",
	});

	$(".side-info-close,.offcanvas-overlay").on("click", function () {
		$(".side-info").removeClass("info-open");
		$(".offcanvas-overlay").removeClass("overlay-open");
	});
	$(".side-toggle").on("click", function () {
		$(".side-info").addClass("info-open");
		$(".offcanvas-overlay").addClass("overlay-open");
	});
	
	// InHover Active 
	$('.dot').on('mouseenter', function () {
		$(this).addClass('active').parent().siblings().find('.dot ').removeClass('active');
	});
	

	// Search
	var $searchWrap = $(".search-wrap");
	var $navSearch = $(".nav-search");
	var $searchClose = $("#search-close");

	$(".search-trigger").on("click", function (e) {
		e.preventDefault();
		$searchWrap.animate({ opacity: "toggle" }, 500);
		$navSearch.add($searchClose).addClass("open");
	});

	$(".search-close").on("click", function (e) {
		e.preventDefault();
		$searchWrap.animate({ opacity: "toggle" }, 500);
		$navSearch.add($searchClose).removeClass("open");
	});

	function closeSearch() {
		$searchWrap.fadeOut(200);
		$navSearch.add($searchClose).removeClass("open");
	}

	$(document.body).on("click", function (e) {
		closeSearch();
	});

	$(".search-trigger, .main-search-input").on("click", function (e) {
		e.stopPropagation();
	});


	$(window).on("scroll", function () {
		var scroll = $(window).scrollTop();
		if (scroll < 245) {
			$(".header-sticky").removeClass("sticky-on");
		} else {
			$(".header-sticky").addClass("sticky-on");
		}
	});

	// Activate rtl slider
    let rtl_setting = $('body').hasClass("rtl") ? true : false;

	// mainSlider
	function mainSlider() {
		var BasicSlider = $(".slider-active");
		BasicSlider.on("init", function (e, slick) {
			var $firstAnimatingElements = $(".single-slider:first-child").find(
				"[data-animation]"
			);
			doAnimations($firstAnimatingElements);
		});
		BasicSlider.on(
			"beforeChange",
			function (e, slick, currentSlide, nextSlide) {
				var $animatingElements = $(
					'.single-slider[data-slick-index="' + nextSlide + '"]'
				).find("[data-animation]");
				doAnimations($animatingElements);
			}
		);
		BasicSlider.slick({
			autoplay: false,
			autoplaySpeed: 10000,
			dots: false,
			fade: true,
			arrows: false,
			responsive: [
				{ breakpoint: 767, settings: { dots: false, arrows: false } },
			],
		});

		function doAnimations(elements) {
			var animationEndEvents =
				"webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
			elements.each(function () {
				var $this = $(this);
				var $animationDelay = $this.data("delay");
				var $animationType = "animated " + $this.data("animation");
				$this.css({
					"animation-delay": $animationDelay,
					"-webkit-animation-delay": $animationDelay,
				});
				$this
					.addClass($animationType)
					.one(animationEndEvents, function () {
						$this.removeClass($animationType);
					});
			});
		}
	}
	mainSlider();

	// data background
	$("[data-background]").each(function () {
		$(this).css(
			"background-image",
			"url(" + $(this).attr("data-background") + ")"
		);
	});


	// nice select
    $(".footer__widget select,.n-sidebar-widget select, .pr-select select").niceSelect();

    function ProjectSlider(){

    var autoplays =  $(".project-slider-active").data('s-autoplay') == true ? true : false;
    var nav =  $(".project-slider-active").data('s-nav') == true ? true : false;
    var autoplay_speed =  $(".project-slider-active").data('s-speed');

	// owlCarousel
	$(".project-slider-active").owlCarousel({
		loop: true,
		margin: 30,
		items: 2,
		navText: [
			'<button class="owl-arrow owl-arrow-prev"><i class="fal fa-arrow-left"></i></button>',
			'<button class="owl-arrow owl-arrow-next"><i class="fal fa-arrow-right"></i></button> ',
		],
		nav: nav,
		autoplay: autoplays,
       autoplaySpeed: autoplay_speed,
		dots: false,
		rtl: rtl_setting,
		responsive: {
			0: {
				items: 1,
			},
			768: {
				items: 2,
			},
			991: {
				items: 1,
			},
			1200: {
				items: 2,
			},
			1400: {
				items: 2,
			},
		},
	});

	var autoplays =  $(".gallery-slider").data('s-autoplay') == true ? true : false;
    var nav =  $(".gallery-slider").data('s-nav') == true ? true : false;
    var autoplay_speed =  $(".gallery-slider").data('s-speed');

	// owlCarousel
	$(".gallery-slider").owlCarousel({
		loop: true,
		margin: 30,
		items: 3,
		navText: [
			'<button class="owl-arrow owl-arrow-prev"><i class="fal fa-arrow-left"></i></button>',
			'<button class="owl-arrow owl-arrow-next"><i class="fal fa-arrow-right"></i></button> ',
		],
		nav: false,
		rtl: rtl_setting,
		dots: false,
		autoplay: autoplays,
      autoplaySpeed: autoplay_speed,
		responsive: {
			0: {
				items: 1,
			},
			767: {
				items: 1,
			},
			992: {
				items: 3,
			},
		},
	});

	var autoplays =  $(".portfolio__active").data('s-autoplay') == true ? true : false;
   var nav =  $(".portfolio__active").data('s-nav') == true ? true : false;
   var dots =  $(".portfolio__active").data('s-dots') == true ? true : false;
   var autoplay_speed =  $(".portfolio__active").data('s-speed');

	// portfolio slider
	$(".portfolio__active").slick({
		infinite: true,
		slidesToShow: 1,
		slidesToScroll: 1,
		arrows: false,
		rtl: rtl_setting,
		dots: dots,
		autoplay: autoplays,
      autoplaySpeed: autoplay_speed,
		responsive: [
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
					dots: false,
				},
			},
		],
	});


   var autoplays =  $(".pd-slider").data('s-autoplay') == true ? true : false;
   var dots =  $(".pd-slider").data('s-dots') == true ? true : false;
   var autoplay_speed =  $(".pd-slider").data('s-speed');


	// project details slider
	$(".pd-slider").slick({
		dots: dots,
		autoplay: autoplays,
      autoplaySpeed: autoplay_speed,
		arrows: false,
		infinite: true,
		speed: 300,
		slidesToShow: 2,
		rtl: rtl_setting,
		slidesToScroll: 1,
		centerPadding: 30,
		responsive: [
			{
				breakpoint: 1400,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
		],
	});


  }

  function testimonialActive(){

  	 var tautoplays =  $(".testimonial__active").data('ts-autoplay') == true ? true : false;
  	 var tnav =  $(".testimonial__active").data('ts-nav') == true ? true : false;
    var tdots =  $(".testimonial__active").data('ts-dots') == true ? true : false;
    var tautoplay_speed =  $(".testimonial__active").data('ts-speed');

	// testimonial slider
	$(".testimonial__active").slick({
		infinite: true,
		slidesToShow: 1,
		slidesToScroll: 1,
		rtl: rtl_setting,
		arrows: tnav,
		dots: tdots,
		autoplay: tautoplays,
      autoplaySpeed: tautoplay_speed,
	});


  	 var autoplays =  $(".testimonial-box__active").data('s-autoplay') == true ? true : false;
  	 var nav =  $(".testimonial-box__active").data('s-nav') == true ? true : false;
    var dots =  $(".testimonial-box__active").data('s-dots') == true ? true : false;
    var autoplay_speed =  $(".testimonial-box__active").data('s-speed');


	// testimonial card slider
	$(".testimonial-box__active").slick({
		dots: dots,
		arrows: nav,
		autoplay: autoplays,
      autoplaySpeed: autoplay_speed,
		infinite: true,
		speed: 300,
		slidesToShow: 3,
		rtl: rtl_setting,
		slidesToScroll: 1,
		responsive: [
			{
				breakpoint: 1199,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
		],
	});

	 var autoplays =  $(".testimonial-border__active").data('s-autoplay') == true ? true : false;
    var autoplay_speed =  $(".testimonial-border__active").data('s-speed');

	// testimonial border slider
	$(".testimonial-border__active").slick({
		dots: false,
		arrows: false,
		autoplay: autoplays,
      autoplaySpeed: autoplay_speed,
		infinite: true,
		rtl: rtl_setting,
		speed: 300,
		slidesToShow: 3,
		slidesToScroll: 1,
		centerPadding: 30,
		responsive: [
			{
				breakpoint: 1199,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
		],
	});

	var autoplays =  $(".brand__active").data('s-autoplay') == true ? true : false;
  var nav =  $(".brand__active").data('s-nav') == true ? true : false;
  var dots =  $(".brand__active").data('s-dots') == true ? true : false;
  var autoplay_speed =  $(".brand__active").data('s-speed');

	// brand slider
	$(".brand__active").slick({
		dots: false,
		arrows: false,
		autoplay: autoplays,
      autoplaySpeed: autoplay_speed,
		infinite: false,
		speed: 300,
		slidesToShow: 3,
		rtl: rtl_setting,
		slidesToScroll: 1,
	    rows: 2,
		responsive: [
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
			// You can unslick at a given breakpoint now by adding:
			// settings: "unslick"
			// instead of a settings object
		],
	});

}


	function userActive(){

	var autoplays =  $(".brand__area-active").data('s-autoplay') == true ? true : false;
  var autoplay_speed =  $(".brand__area-active").data('s-speed');

	// brand area slider
	$(".brand__area-active").slick({
		dots: false,
		arrows: false,
		autoplay: autoplays,
    autoplaySpeed: autoplay_speed,
		infinite: true,
		speed: 300,
		rtl: rtl_setting,
		slidesToShow: 5,
		slidesToScroll: 1,
		responsive: [
			{
				breakpoint: 1200,
				settings: {
					slidesToShow: 4,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 991,
				settings: {
					slidesToShow: 3,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 575,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
			// You can unslick at a given breakpoint now by adding:
			// settings: "unslick"
			// instead of a settings object
		],
	});

   }

   function historyActive(){

  var autoplays =  $(".history__slider-active").data('s-autoplay') == true ? true : false;
  var nav =  $(".history__slider-active").data('s-nav') == true ? true : false;
  var autoplay_speed =  $(".history__slider-active").data('s-speed');

	// history area slider
	$(".history__slider-active").slick({
		dots: false,
		arrows: nav,
		autoplay: autoplays,
    autoplaySpeed: autoplay_speed,
		infinite: false,
		speed: 300,
		slidesToShow: 4,
		rtl: rtl_setting,
		slidesToScroll: 1,
		prevArrow:
			'<button type="button" class="slick-prev"><i class="fal fa-long-arrow-left"></i></button>',
		nextArrow:
			'<button type="button" class="slick-next"><i class="fal fa-long-arrow-right"></i></button>',
		responsive: [
			{
				breakpoint: 1750,
				settings: {
					slidesToShow: 3,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 991,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
				},
			},
			{
				breakpoint: 768,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
				},
			},
			// You can unslick at a given breakpoint now by adding:
			// settings: "unslick"
			// instead of a settings object
		],
	});

   }


	// blog gellery activation
	if (jQuery(".post-gallery-active").length > 0) {
		let sliderActive1 = ".post-gallery-active";
		let sliderInit1 = new Swiper(sliderActive1, {
			// Optional parameters
			slidesPerView: 1,
			slidesPerColumn: 1,
			paginationClickable: true,
			loop: true,
			effect: "fade",

			autoplay: {
				delay: 5000,
			},

			// If we need pagination
			pagination: {
				el: ".slider-swiper-paginations",
				// dynamicBullets: true,
				clickable: true,
			},

			// Navigation arrows
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev",
			},

			a11y: false,
		});

		function animated_swiper(selector, init) {
			let animated = function animated() {
				$(selector + " [data-animation]").each(function () {
					let anim = $(this).data("animation");
					let delay = $(this).data("delay");
					let duration = $(this).data("duration");

					$(this)
						.removeClass("anim" + anim)
						.addClass(anim + " animated")
						.css({
							webkitAnimationDelay: delay,
							animationDelay: delay,
							webkitAnimationDuration: duration,
							animationDuration: duration,
						})
						.one(
							"webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend",
							function () {
								$(this).removeClass(anim + " animated");
							}
						);
				});
			};
			animated();
			// Make animated when slide change
			init.on("slideChange", function () {
				$(sliderActive1 + " [data-animation]").removeClass("animated");
			});
			init.on("slideChange", animated);
		}

		animated_swiper(sliderActive1, sliderInit1);
	}

	/* magnificPopup img view */
	$(".popup-image").magnificPopup({
		type: "image",
		gallery: {
			enabled: true,
		},
	});

	/* magnificPopup video view */
	$(".popup-video").magnificPopup({
		type: "iframe",
	});

	// circle chart bar 
	 $(".circlechart").circlechart();

	// init Isotope
	$('.grid').imagesLoaded( function() {
		
		var $grid = $(".grid").isotope({
			// options
		});
		// filter items on button click
		$(".filter-button-group").on("click", "button", function () {
			var filterValue = $(this).attr("data-filter");
			$grid.isotope({ filter: filterValue });
		});

		//for menu active class
		$(".project-menu button").on("click", function (event) {
			$(this).siblings(".active").removeClass("active");
			$(this).addClass("active");
			event.preventDefault();
		});
	});
	
	// back to top
	$("#scrollToTop").on("click", function () {
		$("body, html").animate({ scrollTop: 0 }, 500);
		return false;
	});

	// scrollToTop
	$.scrollUp({
		scrollName: "scrollUp", // Element ID
		topDistance: "300", // Distance from top before showing element (px)
		topSpeed: 300, // Speed back to top (ms)
		animation: "fade", // Fade, slide, none
		animationInSpeed: 200, // Animation in speed (ms)
		animationOutSpeed: 200, // Animation out speed (ms)
		scrollText: '<i class="fal fa-arrow-up"></i>', // Text for element
		activeOverlay: false, // Set CSS color to display scrollUp active point, e.g '#00FFFF'
	});

	// WOW active
	new WOW().init();

	// counterup
	$(".counter").counterUp({
		delay: 1000,
		time: 1000,
	});

     

     $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/testimonial_slider.default', testimonialActive);
        elementorFrontend.hooks.addAction('frontend/element_ready/project_slider.default', ProjectSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/history.default', historyActive);
        elementorFrontend.hooks.addAction('frontend/element_ready/brand.default', userActive);

    });


})(jQuery);