<?php
/**
 * volport functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package volport
 */

if ( ! function_exists( 'volport_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function volport_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on volport, use a find and replace
		 * to change 'volport' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'volport', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'main-menu' => esc_html__( 'Main Menu', 'volport' ),
			'top-menu' => esc_html__( 'Top Menu', 'volport' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'volport_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		//Enable custom header
		add_theme_support('custom-header');

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		/**
		 * Enable suporrt for Post Formats
		 *
		 * see: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'image',
			'audio',
			'video',
			'gallery',
			'quote',
		) );

		// Add theme support for selective refresh for widgets.
		//add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		remove_theme_support( 'widgets-block-editor' );


		add_image_size( 'volport-case-details', 1170, 600, array('center','center') );
		add_image_size( 'volport-post-thumb', 500, 350, array('center','center') );
		add_image_size( 'volport-case-thumb', 700, 544, array('center','center') );
	}
endif;
add_action( 'after_setup_theme', 'volport_setup' );


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function volport_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'volport_content_width', 640 );
}
add_action( 'after_setup_theme', 'volport_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function volport_widgets_init() {

	$footer_style_2_switch = get_theme_mod('footer_style_2_switch', true );
	$footer_style_3_switch = get_theme_mod('footer_style_3_switch', true );
	$footer_style_4_switch = get_theme_mod('footer_style_4_switch', true );

	/**
	* blog sidebar
	*/
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'volport' ),
		'id'            => 'blog-sidebar',
		'before_widget' => '<div id="%1$s" class="n-sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="sidebar-title"> <h4>',
		'after_title'   => '</h4></div>',
	) );

	$footer_widgets = get_theme_mod('footer_widget_number', 4);


	for( $num=1; $num <= $footer_widgets; $num++ ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Footer '. $num, 'volport'),
			'id'            => 'footer-'. $num,
			'description'   => esc_html__( 'Footer '. $num, 'volport' ),
			'before_widget' => '<div id="%1$s" class="footer__widget c-footer-widget-'.$num.' mb-60 %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5 class="footer__widget-title">',
			'after_title'   => '</h5>',
		) );			
	}


	// footer 2
	if ( $footer_style_2_switch ) {
		for( $num=1; $num <= $footer_widgets; $num++ ) {
			register_sidebar( array(
				'name'          => esc_html__( 'Footer Style 2: '. $num, 'volport'),
				'id'            => 'footer-2-'. $num,
				'description'   => esc_html__( 'Footer Style 2: '. $num, 'volport' ),
				'before_widget' => '<div id="%1$s" class="footer__widget c-footer-widget-2-'.$num.' mb-30 %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="footer__widget-title">',
				'after_title'   => '</h5>',
			) );			
		}
	}

	// footer 3
	if ( $footer_style_3_switch ) {
		for( $num=1; $num <= $footer_widgets; $num++ ) {
			register_sidebar( array(
				'name'          => esc_html__( 'Footer Style 3: '. $num, 'volport'),
				'id'            => 'footer-3-'. $num,
				'description'   => esc_html__( 'Footer Style 3: '. $num, 'volport' ),
				'before_widget' => '<div id="%1$s" class="footer__widget grey-light c-footer-widget-3-'.$num.' mb-30 %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="footer__widget-title">',
				'after_title'   => '</h5>',
			) );			
		}
	}

	// footer 4
	if ( $footer_style_4_switch ) {
		for( $num=1; $num <= $footer_widgets; $num++ ) {
			register_sidebar( array(
				'name'          => esc_html__( 'Footer Style 4: '. $num, 'volport'),
				'id'            => 'footer-4-'. $num,
				'description'   => esc_html__( 'Footer Style 4: '. $num, 'volport' ),
				'before_widget' => '<div id="%1$s" class="footer__widget c-footer-widget-4-'.$num.' mb-30 %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="footer__widget-title nb">',
				'after_title'   => '</h5>',
			) );			
		}
	}

	/**
	* Service Widget
	*/
	register_sidebar(
		array(
			'name' 			=> esc_html__( 'Service Sidebar', 'volport' ),
			'id' 			=> 'services-sidebar',
			'description' 	=> esc_html__( 'Widgets in this area will be shown on Service Details Sidebar.', 'volport' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget mb-40 %2$s">',
			'after_widget' 	=> '</div>',
			'before_title' 	=> '<div class="sidebar-title"><h4>',
			'after_title' 	=> '</h4></div>',
		)
	);	

	/**
	* Portfolio Widget
	*/
	register_sidebar(
		array(
			'name' 			=> esc_html__( 'Portfolio Sidebar', 'volport' ),
			'id' 			=> 'portfolio-sidebar',
			'description' 	=> esc_html__( 'Widgets in this area will be shown on Portfolio Details Sidebar.', 'volport' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget mb-40 %2$s">',
			'after_widget' 	=> '</div>',
			'before_title' 	=> '<div class="sidebar-title"><h4>',
			'after_title' 	=> '</h4></div>',
		)
	);	

}
add_action( 'widgets_init', 'volport_widgets_init' );

/**
 * Enqueue scripts and styles.
 */

define('VOLPORT_THEME_DIR', get_template_directory());
define('VOLPORT_THEME_URI', get_template_directory_uri());
define('VOLPORT_THEME_CSS_DIR', VOLPORT_THEME_URI . '/assets/css/');
define('VOLPORT_THEME_JS_DIR', VOLPORT_THEME_URI . '/assets/js/');
define('VOLPORT_THEME_INC', VOLPORT_THEME_DIR . '/inc/');

/** 
 * volport_scripts description
 * @return [type] [description]
 */
function volport_scripts() {

	/**
	* all css files
	*/

	wp_enqueue_style( 'volport-fonts', volport_fonts_url(), array(), '1.0.0' );

     if( is_rtl() ){
        wp_enqueue_style( 'bootstrap-rtl', VOLPORT_THEME_CSS_DIR.'bootstrap.rtl.min.css', array() );
    }else{
        wp_enqueue_style( 'bootstrap', VOLPORT_THEME_CSS_DIR.'bootstrap.min.css', array() );
    }

	wp_enqueue_style( 'animate', VOLPORT_THEME_CSS_DIR.'animate.min.css', array() );
	wp_enqueue_style( 'custom-animation', VOLPORT_THEME_CSS_DIR.'custom-animation.css', array() );
	wp_enqueue_style( 'flaticon', VOLPORT_THEME_CSS_DIR.'flaticon.css', array() );
	wp_enqueue_style( 'fontawesome-all', VOLPORT_THEME_CSS_DIR.'fontawesome-all.min.css', array() );
	wp_enqueue_style( 'meanmenu', VOLPORT_THEME_CSS_DIR.'meanmenu.css', array() );
	wp_enqueue_style( 'icofont', VOLPORT_THEME_CSS_DIR.'icofont.min.css', array() );
	wp_enqueue_style( 'nice-select', VOLPORT_THEME_CSS_DIR.'nice-select.css', array() );
	wp_enqueue_style( 'magnific-popup', VOLPORT_THEME_CSS_DIR.'magnific-popup.css', array() );
	wp_enqueue_style( 'owl-carousel', VOLPORT_THEME_CSS_DIR.'owl.carousel.min.css', array() );
	wp_enqueue_style( 'pe-icon', VOLPORT_THEME_CSS_DIR.'pe-icon-7-stroke.css', array() );
	wp_enqueue_style( 'preloader', VOLPORT_THEME_CSS_DIR.'preloader.css', array() );
	wp_enqueue_style( 'progresscircle', VOLPORT_THEME_CSS_DIR.'progresscircle.css', array() );
	wp_enqueue_style( 'slick', VOLPORT_THEME_CSS_DIR.'slick.css', array() );
	wp_enqueue_style( 'swipper', VOLPORT_THEME_CSS_DIR.'swipper.css', array() );
	wp_enqueue_style( 'themify-icons', VOLPORT_THEME_CSS_DIR.'themify-icons.css', array() );
	wp_enqueue_style( 'volport-core', VOLPORT_THEME_CSS_DIR.'volport-core.css', array() );
	wp_enqueue_style( 'volport-unit', VOLPORT_THEME_CSS_DIR.'volport-unit.css', array() );
	wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR.'volport-custom.css', array() );
	wp_enqueue_style( 'volport-style', get_stylesheet_uri() );

 
	// all js
	wp_enqueue_script( 'bootstrap-bundle', VOLPORT_THEME_JS_DIR.'bootstrap.bundle.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'isotope', VOLPORT_THEME_JS_DIR.'isotope.pkgd.min.js', array('imagesloaded'), '', true );
	wp_enqueue_script( 'slick', VOLPORT_THEME_JS_DIR.'slick.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'swipper-bundle', VOLPORT_THEME_JS_DIR.'swipper-bundle.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'jquery-counterup', VOLPORT_THEME_JS_DIR.'jquery.counterup.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'nice-select', VOLPORT_THEME_JS_DIR.'jquery.nice-select.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'jquery-magnific-popup', VOLPORT_THEME_JS_DIR.'jquery.magnific-popup.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'jquery-meanmenu', VOLPORT_THEME_JS_DIR.'jquery.meanmenu.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'jquery-scrollup', VOLPORT_THEME_JS_DIR.'jquery.scrollUp.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'owl-carousel', VOLPORT_THEME_JS_DIR.'owl.carousel.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'progresscircle', VOLPORT_THEME_JS_DIR.'progresscircle.js', array('jquery'), '', true );
	wp_enqueue_script( 'waypoint', VOLPORT_THEME_JS_DIR.'waypoint.js', array('jquery'), '', true );
	wp_enqueue_script( 'wow-js', VOLPORT_THEME_JS_DIR.'wow.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'volport-main', VOLPORT_THEME_JS_DIR.'main.js', array('jquery'), false, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'volport_scripts' );

/*
Register Fonts
*/
function volport_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'volport' ) ) {
        $font_url =  'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Roboto:wght@300;400;500;700&display=swap';
    }
    return $font_url;
}


// wp_body_open
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
            do_action( 'wp_body_open' );
    }
}



/**
 * Implement the Custom Header feature.
 */
require VOLPORT_THEME_INC . 'custom-header.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require VOLPORT_THEME_INC . 'template-functions.php';

/**
 * Custom template helper function for this theme.
 */
require VOLPORT_THEME_INC . 'template-helper.php';



/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require VOLPORT_THEME_INC . 'jetpack.php';
}

/**
* include volport functions file
*/
require_once VOLPORT_THEME_INC . 'class-breadcrumb.php';
require_once VOLPORT_THEME_INC . 'class-navwalker.php';
require_once VOLPORT_THEME_INC . 'class-volport-kirki.php';
require_once VOLPORT_THEME_INC . 'kirki-customizer.php';
require_once VOLPORT_THEME_INC . 'class-tgm-plugin-activation.php';
require_once VOLPORT_THEME_INC . 'add_plugin.php';



/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function volport_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'volport_pingback_header' );


/**
*
* comment section
*
*/
add_filter('comment_form_default_fields', 'volport_comment_form_default_fields_func');

function volport_comment_form_default_fields_func($default){

	$default['author'] = '<div class="row">
    <div class="col-xl-6 col-md-6">
    	<div class="post-input">
        	<input type="text" name="author" placeholder="'.esc_attr__('Your Name','volport').'">
        </div>
    </div>';
	$default['email'] = '<div class="col-xl-6 col-md-6">
		<div class="post-input">
        <input type="text" name="email" placeholder="'.esc_attr__('Your Email','volport').'">
    	</div>
    </div>';
	// $default['url'] = '';
	$defaults['comment_field'] = '';

	$default['url'] = '<div class="col-xl-12">
		<div class="post-input">
        <input type="text" name="url" placeholder="'.esc_attr__('Website','volport').'">
    	</div>
    </div>';
	return $default;
}

add_action( 'comment_form_top', 'volport_add_comments_textarea' );
function volport_add_comments_textarea()
{
	if( !is_user_logged_in() ){
    echo '<div class="row"><div class="col-xl-12"><div class="post-input"><textarea id="comment" name="comment" cols="60" rows="6" placeholder="'.esc_attr__('Write your comment here...','volport').'" aria-required="true"></textarea></div></div></div>';
	}
}

add_filter('comment_form_defaults', 'volport_comment_form_defaults_func');

function volport_comment_form_defaults_func($info){
	if( !is_user_logged_in() ){
		$info['comment_field'] = '';
		$info['submit_field'] = '%1$s %2$s</div>';
	}else {
		$info['comment_field'] = '<div class="post-input"><textarea id="comment" name="comment" cols="30" rows="10" placeholder="'.esc_attr__('Comment *','volport').'"></textarea>';
        $info['submit_field'] = '%1$s %2$s</div>';
	}


	$info['submit_button'] = '<div class="col-xl-12"><button class="post-comment shutter-btn" type="submit"><i class="fal fa-comments"></i> '.esc_html__('Post Comment','volport').' </button></div>';

	$info['title_reply_before'] = '<div class="post-comments-title">
                                        <h2>';
	$info['title_reply_after'] = '</h2></div>';
	$info['comment_notes_before'] = '';

	return $info;
}

if( !function_exists('volport_comment') ) {
	function volport_comment($comment, $args, $depth) {
		$GLOBAL['comment'] = $comment;
		extract($args, EXTR_SKIP);
		$args['reply_text'] = '<i class="fal fa-reply"></i> Reply';
		$replayClass = 'comment-depth-' . esc_attr($depth);
		?>
			<li id="comment-<?php comment_ID(); ?>">
				<div class="comments-box">
					<div class="comments-avatar">
						<?php print get_avatar($comment, 102, null, null, array('class'=> array())); ?>
					</div>
					<div class="comments-text">
						<div class="avatar-name">
							<h5><?php print get_comment_author_link(); ?></h5>
							<span><?php comment_time( get_option('date_format') ); ?></span>
						</div>
						<?php comment_text(); ?>
						<?php comment_reply_link( array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'] ))); ?>
					</div>
				</div>
		<?php
	}
}



/**
* shortcode supports for removing extra p, spance etc
*
*/
add_filter( 'the_content', 'volport_shortcode_extra_content_remove' );
/**
 * Filters the content to remove any extra paragraph or break tags
 * caused by shortcodes.
 *
 * @since 1.0.0
 *
 * @param string $content  String of HTML content.
 * @return string $content Amended string of HTML content.
 */
function volport_shortcode_extra_content_remove( $content ) {

    $array = array(
        '<p>['    => '[',
        ']</p>'   => ']',
        ']<br />' => ']'
    );
    return strtr( $content, $array );

}


// volport_search_filter_form
if( !function_exists('volport_search_filter_form')) {
  function volport_search_filter_form( $form ) {
    
    $form = sprintf( 
    	'<div class="sidebar--widget__search"><form class="sidebar-search-form" action="%s" method="get">
      	<input type="text" value="%s" required name="s" placeholder="%s">
      	<button type="submit"> <i class="far fa-search"></i>  </button>
		</form></div>',
		esc_url( home_url('/') ),
		esc_attr( get_search_query() ),
		esc_html__('Search','volport')
	);

    return $form;
  }
  add_filter( 'get_search_form','volport_search_filter_form');
}

add_action('admin_enqueue_scripts', 'volport_admin_custom_scripts');

function volport_admin_custom_scripts() {
	wp_enqueue_media();
	wp_register_script('volport-admin-custom', get_template_directory_uri().'/inc/js/admin_custom.js', array('jquery'), '', true);
	wp_enqueue_script('volport-admin-custom');
}