<?php
/**
 * volport customizer
 *
 * @package volport
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function volport_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'volport_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'volport Customizer', 'volport' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Header Topbar Setting', 'volport' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'header_social', [
        'title'       => esc_html__( 'Header Social', 'volport' ),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'section_header_logo', [
        'title'       => esc_html__( 'Header Setting', 'volport' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'volport' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'header_side_setting', [
        'title'       => esc_html__( 'Side Info', 'volport' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'volport' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'volport' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'volport' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'volport' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'volport' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'volport' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ] );

    $wp_customize->add_section('slug_setting', [
        'title'       => esc_html__('Slug Settings', 'volport'),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'volport_customizer',
    ]);
}

add_action( 'customize_register', 'volport_customizer_panels_sections' );

function _header_top_fields( $fields ) {
    
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_topbar_switch',
        'label'    => esc_html__( 'Topbar Swicher', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_header_lang',
        'label'    => esc_html__( 'Show Language', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];


    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_header_right',
        'label'    => esc_html__( 'Header Right On/Off', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_preloader',
        'label'    => esc_html__( 'Preloader On/Off', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_search_hide',
        'label'    => esc_html__( 'Search On/Off', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_cart_hide',
        'label'    => esc_html__( 'Cart On/Off', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_side_hide',
        'label'    => esc_html__( 'Side Info On/Off', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_language_hide',
        'label'    => esc_html__( 'Language On/Off', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

     $fields[] = [
        'type'        => 'image',
        'settings'    => 'header_support_img',
        'label'       => esc_html__( 'Header Support Image', 'volport' ),
        'description' => esc_html__( 'Header Support Image', 'volport' ),
        'section'     => 'header_top_setting',
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'volport_phone',
        'label'           => esc_html__( 'Phone Number', 'volport' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( '+876 864 764 764', 'volport' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'volport_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'volport_email',
        'label'           => esc_html__( 'Mail ID', 'volport' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( 'info@webmail.comm', 'volport' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'volport_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'            => 'text',
        'settings'        => 'volport_open_hour',
        'label'           => esc_html__( 'Service Hour', 'volport' ),
        'section'         => 'header_top_setting',
        'default'         => esc_html__( '9:30 AM - 6:30 PM', 'volport' ),
        'priority'        => 10,
        'active_callback' => [
            [
                'setting'  => 'volport_topbar_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    // button
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_button_text',
        'label'    => esc_html__( 'Button Text', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( 'Get A Quote', 'volport' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'volport_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'link',
        'settings' => 'volport_button_link',
        'label'    => esc_html__( 'Button URL', 'volport' ),
        'section'  => 'header_top_setting',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'volport_header_right',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];

    return $fields;

}
add_filter( 'kirki/fields', '_header_top_fields' );

/*
Header Social
 */
function _header_social_fields( $fields ) {
    // header section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_topbar_fb_url',
        'label'    => esc_html__( 'Facebook Url', 'volport' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_topbar_twitter_url',
        'label'    => esc_html__( 'Twitter Url', 'volport' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_topbar_linkedin_url',
        'label'    => esc_html__( 'Linkedin Url', 'volport' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_topbar_instagram_url',
        'label'    => esc_html__( 'Instagram Url', 'volport' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_topbar_youtube_url',
        'label'    => esc_html__( 'Youtube Url', 'volport' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_topbar_pinterest_url',
        'label'    => esc_html__( 'Pinterest Url', 'volport' ),
        'section'  => 'header_social',
        'default'  => esc_html__( '#', 'volport' ),
        'priority' => 10,
    ];


    return $fields;
}
add_filter( 'kirki/fields', '_header_social_fields' );

/*
Header Settings
 */
function _header_header_fields( $fields ) {

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Choose Header Style', 'volport' ),
        'section'     => 'section_header_logo',
        'default'     => 'header-style-1',
        'placeholder' => esc_html__( 'Select an option...', 'volport' ),
        'priority'    => 10,
        'choices'     => [
            'header-style-1' => esc_html__( 'Header Style 1', 'volport' ),
            'header-style-2' => esc_html__( 'Header Style 2', 'volport' ),
            'header-style-3' => esc_html__( 'Header Style 3', 'volport' ),
            'header-style-4' => esc_html__( 'Header Style 4', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_header_menu_color',
        'label'       => __( 'Header Style 3 Menu Color', 'volport' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'volport' ),
        'section'     => 'section_header_logo',
        'default'     => '#777777',
        'priority'    => 12,
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header default Logo', 'volport' ),
        'description' => esc_html__( 'Upload Your Logo.', 'volport' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'seconday_logo',
        'label'       => esc_html__( 'Header Secondary Logo', 'volport' ),
        'description' => esc_html__( 'Header Secondary Logo', 'volport' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
    ];    

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo_sticky',
        'label'       => esc_html__( 'Header Sticky Logo', 'volport' ),
        'description' => esc_html__( 'Header Sticky Logo', 'volport' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'favicon_url',
        'label'       => esc_html__( 'Favicon', 'volport' ),
        'description' => esc_html__( 'Favicon Icon', 'volport' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/favicon.png',
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );

/*
Header Side Info
 */
function _header_side_fields( $fields ) {
    // side info settings
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_hamburger_hide',
        'label'    => esc_html__( 'Show Hamburger On/Off', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_extra_contact_info',
        'label'    => esc_html__( 'Extra Contact Swicher', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_extra_map',
        'label'    => esc_html__( 'Extra Map Swicher', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_extra_search',
        'label'    => esc_html__( 'Extra Search Swicher', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_extra_gallery',
        'label'    => esc_html__( 'Extra Gallery Swicher', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'volport_extra_info_logo',
        'label'       => esc_html__( 'Logo Side', 'volport' ),
        'description' => esc_html__( 'Logo Side', 'volport' ),
        'section'     => 'header_side_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-white3.png',
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'volport_extra_about_text',
        'label'    => esc_html__( 'About Us Desc..', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'About Us Desc...', 'volport' ),
        'priority' => 10,
    ];

    // contact
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_extra_contact_title',
        'label'    => esc_html__( 'Contact Title', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Contact Info', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_extra_address',
        'label'    => esc_html__( 'Office Address', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'Johnson Super Street, New York, USA 2344', 'volport' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_extra_phone',
        'label'    => esc_html__( 'Phone Number', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( '(555) 764 890 345', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_extra_email',
        'label'    => esc_html__( 'Email ID', 'volport' ),
        'section'  => 'header_side_setting',
        'default'  => esc_html__( 'info@domain.com', 'volport' ),
        'priority' => 10,
    ];    

    $fields[] = [
        'type'     => 'repeater',
        'label'    => esc_html__( 'Gallery Repeater', 'volport' ),
        'section'  => 'header_side_setting',
        'row_label'=> [
        'type'     => 'text',
        'value'    => esc_html__( 'Client', 'volport' ),
    ],
        
    'button_label' => esc_html__('Add new Photo', 'volport' ),
    'settings'     => 'clients_setting',
        'fields' => [
        'image_client' => [
            'type'         => 'image',
            'label'        => esc_html__( 'Gallery Image', 'volport' ),
            'description'  => esc_attr__( 'Upload Gallery Image', 'volport' ),
            ]
        ]
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_side_fields' );

/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {
    // Breadcrumb Setting

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_breadcrumb_shape_switch',
        'label'    => esc_html__( 'Shape Show/Hide', 'volport' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_bg_img',
        'label'       => esc_html__( 'Breadcrumb Background Image', 'volport' ),
        'description' => esc_html__( 'Breadcrumb Background Image', 'volport' ),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/page-title/page-title.jpg',
    ];
    
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_breadcrumb_bg_color',
        'label'       => __( 'Breadcrumb BG Color', 'volport' ),
        'description' => esc_html__( 'This is a Breadcrumb bg color control.', 'volport' ),
        'section'     => 'breadcrumb_setting',
        'default'     => '#f4f9fc',
        'priority'    => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_breadcrumb_top_spacing',
        'label'    => esc_html__( 'Breadcrumb Padding Top', 'volport' ),
        'section'  => 'breadcrumb_setting',
        'default'  => esc_html__( '160px', 'volport' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_breadcrumb_bottom_spacing',
        'label'    => esc_html__( 'Breadcrumb Padding Bottom', 'volport' ),
        'section'  => 'breadcrumb_setting',
        'default'  => esc_html__( '160px', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_breadcrumb_bottom_spacing',
        'label'    => esc_html__( 'Breadcrumb Padding Bottom', 'volport' ),
        'section'  => 'breadcrumb_setting',
        'default'  => esc_html__( '160px', 'volport' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_blog_btn_switch',
        'label'    => esc_html__( 'Blog BTN On/Off', 'volport' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'volport' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'volport' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_blog_btn_rtl',
        'label'    => esc_html__( 'Blog Button text rtl', 'volport' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'volport' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'volport' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'volport' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'volport' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'volport' ),
        'section'     => 'footer_setting',
        'default'     => 'footer-style-1',
        'placeholder' => esc_html__( 'Select an option...', 'volport' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1' => esc_html__( 'Footer Style 1', 'volport' ),
            'footer-style-2' => esc_html__( 'Footer Style 2', 'volport' ),
            'footer-style-3' => esc_html__( 'Footer Style 3', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'volport' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'volport' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            '5' => esc_html__( 'Widget Number 5', 'volport' ),
            '4' => esc_html__( 'Widget Number 4', 'volport' ),
            '3' => esc_html__( 'Widget Number 3', 'volport' ),
            '2' => esc_html__( 'Widget Number 2', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'volport_footer_bg',
        'label'       => esc_html__( 'Footer Background Image.', 'volport' ),
        'description' => esc_html__( 'Footer Background Image.', 'volport' ),
        'section'     => 'footer_setting',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'volport_footer_logo',
        'label'       => esc_html__( 'Footer default Logo', 'volport' ),
        'description' => esc_html__( 'Upload Your Logo.', 'volport' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-white.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'footer_seconday_logo',
        'label'       => esc_html__( 'Header Secondary Logo', 'volport' ),
        'description' => esc_html__( 'Header Secondary Logo', 'volport' ),
        'section'     => 'footer_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'volport' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'volport' ),
        'section'     => 'footer_setting',
        'default'     => '#f4f9fc',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_Footer_1_menu_hover_color',
        'label'       => __( 'Footer 1 Menu Hover Color', 'volport' ),
        'description' => esc_html__( 'This is Footer 1 Menu Hover color control.', 'volport' ),
        'section'     => 'footer_setting',
        'default'     => '#7127ea',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'volport_footer_logo_switch',
        'label'    => esc_html__( 'Footer Logo On/Off', 'volport' ),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];


    $fields[] = [
        'type'     => 'switch',
        'settings' => 'footer_menu_switch',
        'label'    => esc_html__( 'Footer Menu On/Off', 'volport' ),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'volport' ),
            'off' => esc_html__( 'Disable', 'volport' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_copyright',
        'label'    => esc_html__( 'Copy Right', 'volport' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Copyright &copy; 2022 Theme_pure. All Rights Reserved', 'volport' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'footer_copyright_switch',
                'operator' => '==',
                'value'    => true,
            ],
        ],
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// color
function volport_color_fields( $fields ) {
    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_color_option',
        'label'       => __( 'Volport Theme Color', 'volport' ),
        'description' => esc_html__( 'This is a Theme color control.', 'volport' ),
        'section'     => 'color_setting',
        'default'     => '#ff5e14',
        'priority'    => 10,
    ];
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_primary_color',
        'label'       => __( 'Volport Primary Color', 'volport' ),
        'description' => esc_html__( 'This is volport Primary color control.', 'volport' ),
        'section'     => 'color_setting',
        'default'     => '#1f61a7',
        'priority'    => 10,
    ];     
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_secondary_color',
        'label'       => __( 'Volport Secondary Color', 'volport' ),
        'description' => esc_html__( 'This is volport secondary control.', 'volport' ),
        'section'     => 'color_setting',
        'default'     => '#f02830',
        'priority'    => 10,
    ];    
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_theme_color2',
        'label'       => __( 'Volport Theme Color 2', 'volport' ),
        'description' => esc_html__( 'This is Home Theme Color 2 control.', 'volport' ),
        'section'     => 'color_setting',
        'default'     => '#286bb2',
        'priority'    => 10,
    ];
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'volport_theme_color3',
        'label'       => __( 'Volport Theme Color 3', 'volport' ),
        'description' => esc_html__( 'This is Home Theme Color 3 control.', 'volport' ),
        'section'     => 'color_setting',
        'default'     => '#3a78ba',
        'priority'    => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'volport_color_fields' );

// 404
function volport_404_fields( $fields ) {
    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_error_404_text',
        'label'    => esc_html__( '400 Text', 'volport' ),
        'section'  => '404_page',
        'default'  => esc_html__( '404', 'volport' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_error_title',
        'label'    => esc_html__( 'Not Found Title', 'volport' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Page not found', 'volport' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'volport_error_desc',
        'label'    => esc_html__( '404 Description Text', 'volport' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted', 'volport' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'volport' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'volport' ),
        'priority' => 10,
    ];
    return $fields;

}
add_filter( 'kirki/fields', 'volport_404_fields' );

/**
 * Added Fields
 */
function volport_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => 'regular',
            'line-height'    => '1.5',
            'font-size'      => '16px',
            'text-transform' => 'none',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'body',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h1_setting',
        'label'       => esc_html__( 'Heading Fonts H1', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => '',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h1',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h2_setting',
        'label'       => esc_html__( 'Heading Fonts H2', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => '',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h2',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h3_setting',
        'label'       => esc_html__( 'Heading Fonts H3', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => '',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h3',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h4_setting',
        'label'       => esc_html__( 'Heading Fonts H4', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => '',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h4',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h5_setting',
        'label'       => esc_html__( 'Heading Fonts H5', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => '',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h5',
            ],
        ],
    ];
    
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h6_setting',
        'label'       => esc_html__( 'Heading Fonts H6', 'volport' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => 'Rubik',
            'variant'        => '',
        ],
        'priority'    => 18,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h6',
            ],
        ],
    ];
    return $fields;
}

add_filter( 'kirki/fields', 'volport_typo_fields' );


/**
 * Added Fields
 */
function volport_slug_setting($fields)
{
    // slug settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_sv_name',
        'label'    => esc_html__('Service Name', 'volport'),
        'section'  => 'slug_setting',
        'default'  => esc_html__('Services', 'volport'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_sv_slug',
        'label'    => esc_html__('Service Slug', 'volport'),
        'section'  => 'slug_setting',
        'default'  => esc_html__('ourservices', 'volport'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_cases_slug',
        'label'    => esc_html__('Portfolio Slug', 'volport'),
        'section'  => 'slug_setting',
        'default'  => esc_html__('ourcases', 'volport'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'volport_cases_name',
        'label'    => esc_html__('Cases Name', 'volport'),
        'section'  => 'slug_setting',
        'default'  => esc_html__('Cases', 'volport'),
        'priority' => 10,
    ];

    return $fields;
}

add_filter('kirki/fields', 'volport_slug_setting');


/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function volport_theme_option( $name ) {
    $value = '';
    if ( class_exists( 'volport' ) ) {
        $value = Kirki::get_option( volport_get_theme(), $name );
    }

    return apply_filters( 'volport_theme_option', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function volport_get_theme() {
    return 'volport';
}