<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package volport
 */

/**
*
* volport header
*/

function volport_check_header() {
    $volport_header_style = function_exists('get_field') ? get_field( 'header_style' ) : NULL;
    $volport_default_header_style = get_theme_mod('choose_default_header', 'header-style-1' );

    if( $volport_header_style == 'header-style-1' ) {
        volport_header_style_1();
    }
    elseif( $volport_header_style == 'header-style-2' ) {
        volport_header_style_2();
    }  
    elseif( $volport_header_style == 'header-style-3' ) {
        volport_header_style_3();
    }
    elseif( $volport_header_style == 'header-style-4' ) {
        volport_header_style_4();
    }
    else {
        
        /** default header style **/
        if($volport_default_header_style == 'header-style-2') {
            volport_header_style_2();
        }
        elseif($volport_default_header_style == 'header-style-3') {
            volport_header_style_3();
        }
        elseif($volport_default_header_style == 'header-style-4') {
            volport_header_style_4();
        }
        else {
            volport_header_style_1();
        }
    }

}
add_action('volport_header_style', 'volport_check_header', 10);

/**
* header style 1 + default
*/

function volport_header_style_1() {

    $volport_cart_hide = get_theme_mod('volport_cart_hide', false);
    $volport_search_hide = get_theme_mod('volport_search_hide', false);
    $volport_side_hide = get_theme_mod('volport_side_hide', false);
    $volport_header_right = get_theme_mod('volport_header_right', false);


    $volport_menu_col =  $volport_header_right ? 'col-xl-8 col-lg-8 d-none d-lg-block' : 'text-end col-xl-10 col-lg-10 d-none d-lg-block';

    $volport_mobile_menu_col = $volport_header_right ? 'd-none' : 'd-lg-none col-md-6 col-6 text-end';


    if (rtl_enable()) {
        $btn_text = get_theme_mod('volport_button_text_rtl', __('Get A Quote','volport'));
    }
    else { 
        $btn_text = get_theme_mod('volport_button_text', __('Get A Quote','volport'));
    }
    
    $btn_link = get_theme_mod('volport_button_link', __('#','volport'));

    ?>

    <!-- header area start here -->
    <header>
        <div class="transparent-header header-sticky default-head">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-2 col-lg-2 col-6">
                        <div class="logo">
                            <?php volport_header_logo(); ?>
                        </div>
                    </div>
                    <div class="<?php print esc_attr($volport_menu_col); ?>">
                        <div class="main-menu main-menu-1 ml-40">
                            <nav id="mobile-menu">
                                <?php volport_header_menu(); ?>
                            </nav>
                        </div>
                    </div>

                    <?php if(!empty($volport_header_right)) : ?>
                    <div class="col-xl-2 col-lg-2 col-6">
                        <div class="header__icons s_header_icon f-right">
                            <ul>
                                <?php if(!empty($volport_search_hide)) : ?>
                                <li><a class="nav-search search-trigger" href="#"><i class="pe-7s-search"></i></a></li>
                                <?php endif; ?>

                                <?php if(!empty($volport_cart_hide)) : ?>
                                <li><a href="#"><i class="pe-7s-cart"></i></a></li>
                                <?php endif; ?>

                                <li><a class="side-toggle" href="javascript:void(0)"><i class="pe-7s-keypad"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>


                    <div class="<?php print esc_attr($volport_mobile_menu_col); ?>">
                        <div class="header__icons f-right">
                            <ul>
                                <li><a class="side-toggle" href="javascript:void(0)"><i class="pe-7s-keypad"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <?php volport_extra_info(); ?>


    
<?php 
}

/**
* header style 2 
*/
function volport_header_style_2() {
    $volport_side_hide = get_theme_mod('volport_side_hide', false);
    $volport_search_hide = get_theme_mod('volport_search_hide', false);

    $volport_header_right = get_theme_mod('volport_header_right', false);
    $volport_menu_col =  $volport_header_right ? 'col-xxl-6 col-xl-6 col-lg-8 d-none d-lg-block' : 'text-end col-xxl-9 col-xl-9 col-lg-8 d-none d-lg-block';
    $volport_menu_right =  $volport_header_right ? 'text-center' : 'text-right';

    if (rtl_enable()) {
        $btn_text = get_theme_mod('volport_button_text_rtl', __('Get A Quote','volport'));
    }
    else { 
        $btn_text = get_theme_mod('volport_button_text', __('Get A Quote','volport'));
    }
    
    $btn_link = get_theme_mod('volport_button_link', __('#','volport'));

    ?>

    <!-- header area start here -->
    <header>
        <div class="transparent-header transparent-header-2 header-sticky sticky-3">
            <div class="container">
                <div class="header__inner white-bg">
                    <div class="row align-items-center">
                        <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-8 col-sm-8">
                            <div class="header__left d-flex align-items-center justify-content-between justify-content-lg-start">
                                <?php if(!empty($volport_side_hide)) : ?>
                                <div class="header__action-2 mr-40">
                                    <ul>
                                        <li>
                                            <a class="side-toggle" href="javascript:void(0)">
                                                <i class="pe-7s-keypad"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <?php endif; ?>
                                <div class="logo-1">
                                    <?php volport_header_logo(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="<?php print esc_attr($volport_menu_col); ?>">
                            <div class="main-menu main-menu-2 pl-20">
                                <nav id="mobile-menu">
                                    <?php volport_header_menu(); ?>
                                </nav>
                            </div>
                        </div>

                        <?php if(!empty($volport_header_right)) : ?>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-4  ">
                            <div class="header__right d-flex justify-content-end justify-content-xxl-between align-items-center pr-20">
                                <?php if(!empty($volport_search_hide)) : ?>
                                <div class="header__search d-none d-sm-block  d-lg-none d-xxl-block">
                                    <button type="button" class="search-trigger"><i class="pe-7s-search"></i></button>
                                </div>
                                <?php endif; ?>

                                <?php if(!empty($btn_text)) : ?>
                                <div class="header__btn d-none d-xl-block">
                                    <a href="<?php print esc_url($btn_link); ?>" class="v-btn header-tp-btn"><?php print esc_html($btn_text); ?> 
                                        <i class="fal fa-arrow-alt-right"></i>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <?php volport_extra_info(); ?>

<?php 
}

/**
* header style 3
*/
function volport_header_style_3() {
    $volport_language_hide = get_theme_mod('volport_language_hide', false);
    $volport_header_right = get_theme_mod('volport_header_right', false);

    $volport_menu_col =  $volport_header_right ? 'col-xl-8 col-lg-8 d-none d-lg-block' : 'col-12';


    if (rtl_enable()) {
        $btn_text = get_theme_mod('volport_button_text_rtl', __('Find A Location','volport'));
    }
    else { 
        $btn_text = get_theme_mod('volport_button_text', __('Find A Location','volport'));
    }
    
    $btn_link = get_theme_mod('volport_button_link', __('#','volport'));


    ?>


    <!-- header area start here -->

    <header>
        <div class="color-header color-header-2 c2 header-sticky">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-2 col-lg-2 col-7">
                        <div class="logo">
                            <?php volport_header_logo(); ?>
                        </div>
                    </div>

                    <div class="col-xl-10 col-lg-10 d-none d-lg-block">
                        <?php if(!empty($volport_header_right)) : ?>
                        <div class="header__action header__action-3 f-right">
                            <?php if(!empty($volport_language_hide)) : ?>
                            <ul class="language">
                                <li><a href="#"><?php print esc_html__('English', 'volport'); ?></a>
                                    <ul class="submenu">
                                        <li><a href="#"><?php print esc_html__('French', 'volport'); ?></a></li>
                                        <li><a href="#"><?php print esc_html__('Japanese', 'volport'); ?></a></li>
                                        <li><a href="#"><?php print esc_html__('Chinese', 'volport'); ?></a></li>
                                        <li><a href="#"><?php print esc_html__('Russian', 'volport'); ?></a></li>
                                    </ul>
                                </li>
                            </ul>
                            <?php endif; ?>

                            <?php if(!empty($btn_text)) : ?>
                            <div class="header__action-location d-none d-xl-inline-block">
                                <a href="<?php print esc_url($btn_link); ?>" class="location-btn"><i class="fal fa-map-marker-alt"></i>
                                    <?php print esc_html($btn_text); ?>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>

                        <div class="main-menu main-menu-3 f-right"> 
                            <nav id="mobile-menu">
                                <?php volport_header_menu(); ?>
                            </nav>
                        </div>
                    </div>

                    <div class="col-5 d-lg-none">
                        <div class="header__icons f-right c2">
                            <ul>
                                <li><a class="side-toggle" href="javascript:void(0)"><i class="pe-7s-keypad"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <?php volport_extra_info(); ?>

<?php 
}

// header 4
function volport_header_style_4() {

    $volport_cart_hide = get_theme_mod('volport_cart_hide', false);
    $volport_search_hide = get_theme_mod('volport_search_hide', false);
    $volport_side_hide = get_theme_mod('volport_side_hide', false);

    $header_support_img = get_theme_mod('header_support_img', false);

    $volport_phone = get_theme_mod('volport_phone', __('+35 (70) 8796 054','volport'));
    $volport_open_hour = get_theme_mod('volport_open_hour', __('Mon-Sat 8am 6pm','volport'));

    $volport_header_right = get_theme_mod('volport_header_right', false);
    $volport_menu_col =  $volport_header_right ? 'col-xxl-6 col-xl-8 col-lg-6 col-4' : 'col-xxl-10 col-xl-10 col-lg-9 col-4';
    $volport_menu_right =  $volport_header_right ? 'text-center' : 'text-right';

    if (rtl_enable()) {
        $btn_text = get_theme_mod('volport_button_text_rtl', __('Login / Register','volport'));
    }
    else { 
        $btn_text = get_theme_mod('volport_button_text', __('Login / Register','volport'));
    }
    
    $btn_link = get_theme_mod('volport_button_link', __('#','volport'));

    ?>

    <!-- header area start here -->
    
    <header class="p-relative black-bg">
        <div class="header__cta">
            <div class="logo f-left p-0">
                <?php volport_header_logo(); ?>
            </div>
            <div class="cta__content d-none d-md-inline-block">
                <ul>
                    <?php if( !empty($volport_phone) ) : ?>
                    <li>
                        <div class="cta__icon">
                            <i class="flaticon-support"></i>
                        </div>
                        <div class="cta__meta c3">
                            <p><?php print esc_html__('Free Resevation', 'volport'); ?></p>
                            <span><a href="tel:<?php print esc_url( $volport_phone ); ?>"><?php print esc_html( $volport_phone ); ?></a></span>
                        </div>
                    </li>
                    <?php endif; ?>

                    <?php if( !empty($volport_open_hour) ) : ?>
                    <li class="d-none d-xl-inline-block">
                        <div class="cta__icon">
                            <i class="flaticon-stopwatch"></i>
                        </div>
                        <div class="cta__meta c3">
                            <p><?php print esc_html__('The Office Hours', 'volport'); ?></p>
                            <span><?php print esc_html( $volport_open_hour ); ?></span>
                        </div>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="cta__content f-right d-none d-lg-inline-block">
                <ul>
                    <li>
                        <?php if( !empty($header_support_img) ) : ?>
                        <div class="support-img">
                            <img src="<?php print esc_attr($header_support_img); ?>" alt="<?php bloginfo( 'name' ); ?>">
                        </div>
                        <?php endif; ?>
                        <div class="cta__meta text-end c3">
                            <span><?php print esc_html__('Live Support', 'volport'); ?></span>
                            <p><?php print esc_html__('Available', 'volport'); ?></p>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="menu-sidebar d-lg-none">
                <div class="header__icons f-right">
                    <ul>
                        <li><a class="side-toggle" href="javascript:void(0)"><i class="pe-7s-keypad"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="color-header c3 d-none d-lg-block">
            <div class="main-menu main-menu-1">
                <nav id="mobile-menu">
                    <?php volport_header_menu(); ?>
                </nav>
            </div>
        </div>
        <div class="header__login text-center d-none d-lg-block">
            <?php if(!empty($btn_text)) : ?>
            <div class="header__login-title">
                <i class="fal fa-lock"></i>
                <h5><a href="<?php print esc_url($btn_link); ?>"><?php print esc_html($btn_text); ?></a></h5>
            </div>
            <?php endif; ?>

            <ul class="header__login-social">
                <?php volport_mobile_social_profiles(); ?>
            </ul>

            <?php if( !empty($volport_phone) ) : ?>
            <div class="header__login-number">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/icon/hand-phone.png" alt="<?php bloginfo( 'name' ); ?>">
                <span><a href="tel:<?php print esc_url( $volport_phone ); ?>"><?php print esc_html( $volport_phone ); ?></a></span>
            </div>
            <?php endif; ?>
        </div>
        <div class="hidden-menu header-sticky sticky-2">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-2 col-lg-2 col-6">
                        <div class="logo">
                            <?php volport_header_logo(); ?>
                        </div>
                    </div>
                    <div class="col-xl-8 col-lg-8 d-none d-lg-block">
                        <div class="main-menu ml-40">
                            <nav>
                                <?php volport_header_menu(); ?>
                            </nav>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-2 col-6">
                        <div class="header__icons f-right">
                            <ul>
                                <?php if(!empty($volport_search_hide)) : ?>
                                <li><a class="nav-search search-trigger" href="#"><i class="pe-7s-search"></i></a></li>
                                <?php endif; ?>

                                <?php if(!empty($volport_cart_hide)) : ?>
                                <li><a href="#"><i class="pe-7s-cart"></i></a></li>
                                <?php endif; ?>

                                <?php if(!empty($volport_side_hide)) : ?>
                                <li><a class="side-toggle" href="javascript:void(0)"><i class="pe-7s-keypad"></i></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <?php volport_extra_info(); ?>


    
<?php 
}


/** 
 * [volport_extra_info description]
 * @return [type] [description]
 */
function volport_extra_info(){

    $volport_extra_contact_info = get_theme_mod('volport_extra_contact_info', false);
    $volport_extra_search = get_theme_mod('volport_extra_search', false);
    $volport_extra_map = get_theme_mod('volport_extra_map', false);
    $volport_extra_gallery = get_theme_mod('volport_extra_gallery', false);

    $volport_extra_info_logo   = get_theme_mod('volport_extra_info_logo',get_template_directory_uri() . '/assets/img/logo/logo.png');

    // about title
    $volport_extra_about_text     = get_theme_mod('volport_extra_about_text', __('But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and will give you a complete account of the system and expound the actual teachings of the great explore','volport'));
    $volport_extra_contact_title     = get_theme_mod('volport_extra_contact_title', __('Contact Info','volport'));

    // address
    $volport_extra_address     = get_theme_mod('volport_extra_address', __('12/A, Mirnada City Tower, NYC','volport'));

    // phone 
    $volport_extra_phone   = get_theme_mod('volport_extra_phone', __('088889797697','volport'));

    // email 
    $volport_extra_email  = get_theme_mod('volport_extra_email', __('admin@domain.com','volport'));

    $clients = get_theme_mod( 'clients_setting');
    
?>


    <!-- side toggle start  -->
    <div class="fix">
        <div class="side-info">
            <div class="side-info-content">
                <div class="offset-widget offset-logo mb-30 pb-20">
                    <div class="row align-items-center">
                        <?php if( !empty($volport_extra_info_logo) ) : ?>
                        <div class="col-9">
                            <div class="side-logo">
                                <a href="<?php print esc_url(home_url('/')); ?>"><img src="<?php print esc_url( $volport_extra_info_logo ); ?>" alt="<?php print esc_attr('Logo', 'volport'); ?>"></a>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="col-3 text-end">
                            <button class="side-info-close">
                                <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="mobile-menu d-lg-none"></div>

                <?php if(!empty($volport_extra_search)) : ?>
                <div class="offset-widget offset_searchbar mb-30">
                    <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                        <div class="offset_search_content">
                            <input type="search" name="s" value="<?php print esc_attr( get_search_query() )?>" placeholder="<?php print esc_attr__( 'What are you searching for?', 'volport' );?> ">
                            <button type="submit" class="offset_search_button"><i class="fal fa-search"></i></button>
                        </div>
                    </form>
                </div>
                <?php endif; ?>

                <?php if(!empty($volport_extra_contact_info)) : ?>
                <div class="offset-widget mb-40 d-none d-lg-block">
                    <?php if( !empty($volport_extra_about_text) ) : ?>
                    <div class="info-widget">
                        <h4 class="offset-title mb-20 d-none"><?php print esc_html__( 'About Us', 'volport' );?></h4>

                        <p class="mb-30"><?php print esc_html( $volport_extra_about_text ); ?></p>
                        <a href="#" class="c-btn btn-round-02 d-none"><?php print esc_html__( 'Contact Us', 'volport' );?></a>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <?php if(!empty($image_client)) : ?>
                <?php if( !empty($clients) ) : ?>
                <div class="row side-gallery gx-4">
                    <?php foreach( $clients as $client ) : ?>
                    <div class="col-4 mb-20">
                        <div class="side-image">
                            <a class="popup-image" href="<?php echo wp_get_attachment_url( $client['image_client'] ); ?>">
                                <img src="<?php echo wp_get_attachment_url( $client['image_client'] ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            </a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
                <?php endif; ?>

                <?php if(!empty($volport_extra_map)) : ?>
                <div class="side-map mt-20 mb-30 d-none d-lg-block">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d96873.54747609403!2d-74.01503716167228!3d40.645353094718686!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c24416947c2109%3A0x82765c7404007886!2sBrooklyn%2C%20NY%2C%20USA!5e0!3m2!1sen!2sbd!4v1625476308836!5m2!1sen!2sbd"></iframe>
                </div>
                <?php endif; ?>

                <?php if(!empty($volport_extra_contact_info)) : ?>
                <div class="contact-infos mt-30 mb-30">
                    <div class="contact-list mb-30">
                        <?php if( !empty($volport_extra_contact_title) ) : ?>
                        <h4><?php print esc_html( $volport_extra_contact_title ); ?></h4>
                        <?php endif; ?>

                        <?php if( !empty($volport_extra_address) ) : ?>
                        <a href="#" class="">
                            <i class="fal fa-map-marker-alt"></i>
                            <span>
                                <?php print esc_html( $volport_extra_address ); ?>
                            </span>
                        </a>
                        <?php endif; ?>

                        <?php if( !empty($volport_extra_phone) ) : ?>
                        <a href="tel:<?php print esc_url( $volport_extra_phone ); ?>" class="">
                            <i class="fal fa-phone"></i>
                            <span><?php print esc_html( $volport_extra_phone ); ?></span>
                        </a>
                        <?php endif; ?>

                        <?php if( !empty($volport_extra_email) ) : ?>
                        <a href="mailto:<?php print esc_url( $volport_extra_email ); ?>" class="">
                            <i class="far fa-envelope"></i>
                            <span><?php print esc_html( $volport_extra_email ); ?></span>
                        </a>
                        <?php endif; ?>
                    </div>


                    <ul class="footer__social offset-social">
                        <?php volport_mobile_social_profiles(); ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="offcanvas-overlay"></div>
    <!-- side toggle end -->


<?php }


// volport_mobile_sidebar
function volport_mobile_sidebar(){
    $volport_mail_id = get_theme_mod('volport_mail_id', __('info@sycho24.com','volport'));
    $volport_address = get_theme_mod('volport_address', __('28/4 Palmal, London','volport'));
    $volport_open_hour = get_theme_mod('volport_open_hour', __('Sunday to Thursday','volport'));
    $volport_contact_label = get_theme_mod('volport_contact_label', __('Contact Info','volport'));
    $volport_mobile_info = get_theme_mod('volport_mobile_info', false);
?>

    <div class="fix d-none">
        <div class="side-info">
            <button class="side-info-close"><i class="fal fa-times"></i></button>
            <div class="side-info-content">
                <div class="mobile-menu"></div>
                <?php if(!empty($volport_mobile_info)) : ?>
                <div class="contact-infos mb-30">
                    <div class="contact-list mb-30">
                        <h4><?php print esc_html($volport_contact_label); ?></h4>
                        <ul>
                            <?php if(!empty($volport_open_hour)) : ?>
                            <li><i class="flaticon-history"></i><?php print esc_html($volport_open_hour); ?></li>
                            <?php endif; ?>
                            <?php if(!empty($volport_address)) : ?>
                            <li><i class="flaticon-pin"></i><?php print esc_html($volport_address); ?></li>
                            <?php endif; ?>
                            <?php if(!empty($volport_mail_id)) : ?>
                            <li><i class="fal fa-envelope"></i><a href="mailto:<?php print esc_url($volport_mail_id); ?>"><?php print esc_html($volport_mail_id); ?></a></li>
                            <?php endif; ?>
                        </ul>
                        <div class="sidebar__menu--social">
                            <?php volport_mobile_social_profiles(); ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="offcanvas-overlay"></div>


<?php }

/** 
 * [volport_header_lang description]
 * @return [type] [description]
 */
function volport_header_lang_defualt() {
    $volport_header_lang            = get_theme_mod('volport_header_lang',false);
    if( $volport_header_lang ): ?>


    <li class="language"><?php print esc_html__('Eng', 'volport'); ?></a>
    <?php do_action('volport_language'); ?>
    </li>


    <?php endif; ?>
<?php 
}

/** 
 * [volport_language_list description]
 * @return [type] [description]
 */
function _volport_language($mar) {
        return $mar;
}
function volport_language_list() {

    $mar = '';
    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=id&order=desc' );
    if ( !empty( $languages ) ) {
        $mar = '<ul>';
            foreach($languages as $lan){
                $active = $lan['active']==1?'active':'';
                $mar .= '<a class="'.$active.'" href="'.$lan['url'].'">'.$lan['translated_name'].'</a>';
            }
        $mar .= '</ul>';
    }else{
        //remove this code when send themeforest reviewer team
        $mar .= '<div class="language-dropdown">';
            $mar .= '<a href="#">'.esc_html__('Fre','volport').'</a>';
            $mar .= '<a href="#">'.esc_html__('Chi','volport').'</a>';
            $mar .= '<a href="#">'.esc_html__('Jap','volport').'</a>';
            $mar .= '<a href="#">'.esc_html__('Rus','volport').'</a>';
        $mar .= ' </div>';
    }
    print _volport_language($mar);
}
add_action('volport_language','volport_language_list');


// header logo
function volport_header_logo() {
    ?>
        <?php 
        $volport_logo_on = function_exists('get_field') ? get_field('is_enable_sec_logo') : NULL;
        $volport_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
        $volport_logo_black = get_template_directory_uri() . '/assets/img/logo/logo-black.png';

        $volport_site_logo = get_theme_mod('logo', $volport_logo);
        $volport_secondary_logo = get_theme_mod('seconday_logo', $volport_logo_black);
        ?>
         
        <?php
        if( has_custom_logo()){
            the_custom_logo();
        }else{
            
            if( !empty($volport_logo_on) ) { ?>
                <a class="standard-logo" href="<?php print esc_url(home_url('/')); ?>">
                    <img src="<?php print esc_url($volport_secondary_logo); ?>" alt="<?php print esc_attr__('logo','volport'); ?>" />
                </a>
            <?php 
            }
            else{ ?>
                <a class="standard-logo-white" href="<?php print esc_url(home_url('/')); ?>">
                    <img src="<?php print esc_url($volport_site_logo); ?>" alt="<?php print esc_attr__('logo','volport'); ?>" />
                </a>
            <?php 
            }
        }   
        ?>
    <?php 
} 

// header logo
function volport_header_sticky_logo() {
    ?>
        <?php 
        $volport_logo = get_template_directory_uri() . '/assets/images/logo/logo-gradient.png';

        $volport_site_logo = get_theme_mod('logo_sticky', $volport_logo);
        ?>
         
        <?php
        if( has_custom_logo()){
            the_custom_logo();
        }else{?>
            
            <a class="standard-logo-white" href="<?php print esc_url(home_url('/')); ?>">
                <img src="<?php print esc_url($volport_site_logo); ?>" alt="<?php print esc_attr__('logo','volport'); ?>" />
            </a>
           <?php 
            
        }   
        ?>
    <?php 
} 

/** 
 * [volport_header_social_profiles description]
 * @return [type] [description]
 */
function volport_header_social_profiles() {
    $volport_topbar_fb_url             = get_theme_mod('volport_topbar_fb_url', __('#','volport'));
    $volport_topbar_twitter_url       = get_theme_mod('volport_topbar_twitter_url', __('#','volport'));
    $volport_topbar_instagram_url      = get_theme_mod('volport_topbar_instagram_url', __('#','volport'));
    $volport_topbar_linkedin_url      = get_theme_mod('volport_topbar_linkedin_url', __('#','volport'));
    $volport_topbar_youtube_url        = get_theme_mod('volport_topbar_youtube_url', __('#','volport'));
    ?> 

    <?php if (!empty($volport_topbar_fb_url)): ?>
    <li>
      <a href="<?php print esc_url($volport_topbar_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_twitter_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_instagram_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_linkedin_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_linkedin_url); ?>"><i class="fab fa-linkedin"></i></a>
    </li>
    <?php endif; ?>        

    <?php if (!empty($volport_topbar_youtube_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_youtube_url); ?>"><i class="fab fa-youtube"></i></a>
    </li>
    <?php endif; ?>
<?php 
}

// volport_mobile_social_profiles
function volport_mobile_social_profiles() {
    $volport_topbar_fb_url             = get_theme_mod('volport_topbar_fb_url', __('#','volport'));
    $volport_topbar_twitter_url       = get_theme_mod('volport_topbar_twitter_url', __('#','volport'));
    $volport_topbar_instagram_url      = get_theme_mod('volport_topbar_instagram_url', __('#','volport'));
    $volport_topbar_linkedin_url      = get_theme_mod('volport_topbar_linkedin_url', __('#','volport'));
    $volport_topbar_youtube_url        = get_theme_mod('volport_topbar_youtube_url', __('#','volport'));
    ?> 
    <?php if (!empty($volport_topbar_fb_url)): ?>
    <li>
      <a href="<?php print esc_url($volport_topbar_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_twitter_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_instagram_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_linkedin_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_linkedin_url); ?>"><i class="fab fa-linkedin"></i></a>
    </li>
    <?php endif; ?>        

    <?php if (!empty($volport_topbar_youtube_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_youtube_url); ?>"><i class="fab fa-youtube"></i></a>
    </li>
    <?php endif; ?>
<?php 
}

// volport_footer_social_profiles
function volport_footer_social_profiles() {
    $volport_topbar_fb_url             = get_theme_mod('volport_topbar_fb_url', __('#','volport'));
    $volport_topbar_twitter_url       = get_theme_mod('volport_topbar_twitter_url', __('#','volport'));
    $volport_topbar_instagram_url      = get_theme_mod('volport_topbar_instagram_url', __('#','volport'));
    $volport_topbar_linkedin_url      = get_theme_mod('volport_topbar_linkedin_url', __('#','volport'));
    $volport_topbar_youtube_url        = get_theme_mod('volport_topbar_youtube_url', __('#','volport'));
    ?> 
    <?php if (!empty($volport_topbar_fb_url)): ?>
    <li>
      <a href="<?php print esc_url($volport_topbar_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_twitter_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_instagram_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
    </li>
    <?php endif; ?>

    <?php if (!empty($volport_topbar_linkedin_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_linkedin_url); ?>"><i class="fab fa-linkedin"></i></a>
    </li>
    <?php endif; ?>        

    <?php if (!empty($volport_topbar_youtube_url)): ?>
    <li>
        <a href="<?php print esc_url($volport_topbar_youtube_url); ?>"><i class="fab fa-youtube"></i></a>
    </li>
    <?php endif; ?>
<?php 
}


/** 
 * [volport_header_menu description]
 * @return [type] [description]
 */
function volport_header_menu() { ?>
            <?php 
            wp_nav_menu(array(
                'theme_location'    => 'main-menu',
                'menu_class'        => '',
                'container'         => '',
                'fallback_cb'       => 'Navwalker_Class::fallback',
                'walker'            => new Navwalker_Class
            ));
           ?>
    <?php 
}

/**
 * [volport_header_menu description]
 * @return [type] [description]
 */
function volport_mobile_menu() { ?>
    <?php
    $volport_menu = wp_nav_menu( array(
        'theme_location' => 'main-menu',
        'menu_class'     => '',
        'container'      => '',
        'menu_id'        => 'mobile-menu-active',
        'echo'           => false
    ) );

    $volport_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $volport_menu );
    echo wp_kses_post( $volport_menu );
    ?>
    <?php
}

/** 
 * [volport_footer_menu description]
 * @return [type] [description]
 */
function volport_top_menu() { 
    wp_nav_menu(array(
        'theme_location'    => 'top-menu',
        'menu_class'        => 'm-0',
        'container'         => '',
        'fallback_cb'       => 'Navwalker_Class::fallback',
        'walker'            => new Navwalker_Class
    ));
}

/**
*
* volport footer
*/
add_action('volport_footer_style', 'volport_check_footer', 10);

function volport_check_footer() {
    $volport_footer_style = function_exists('get_field') ? get_field( 'footer_style' ) : NULL;
    $volport_default_footer_style = get_theme_mod('choose_default_footer', 'footer-style-1' );
   
    if( $volport_footer_style == 'footer-style-1' ) {
        volport_footer_style_1();
    }    
    elseif( $volport_footer_style == 'footer-style-2' ) {
        volport_footer_style_2();
    } 
    elseif( $volport_footer_style == 'footer-style-3' ) {
        volport_footer_style_3();
    }
    elseif( $volport_footer_style == 'footer-style-4' ) {
        volport_footer_style_4();
    } 
    else{

        /** default footer style **/
        if($volport_default_footer_style == 'footer-style-4') {
           volport_footer_style_4();
        } 
        elseif($volport_default_footer_style == 'footer-style-3') {
           volport_footer_style_3();
        } 
        elseif($volport_default_footer_style == 'footer-style-2') {
           volport_footer_style_2();
        } 
        else {
            volport_footer_style_1();
        }

    }
}

/**
* footer  style_defaut
*/
function volport_footer_style_1() {
    $footer_menu_switch = get_theme_mod('footer_menu_switch', false);

    $footer_bg_img = get_theme_mod('volport_footer_bg');
    $volport_footer_logo = get_theme_mod('volport_footer_logo');
    $volport_footer_page_logo = function_exists('get_field') ? get_field('volport_footer_page_logo') : '';
    $volport_footer_social = get_theme_mod('volport_footer_social');
    $volport_footer_top_space = function_exists('get_field') ? get_field('volport_footer_top_space') : '0';
    $volport_copyright_center = $volport_footer_social ? 'col-md-7' : 'col-lg-12 pt-20 pb-20 text-center';
    $volport_footer_bg_url_from_page = function_exists('get_field') ? get_field('volport_footer_bg') : '';
    $volport_footer_bg_color_from_page = function_exists('get_field') ? get_field('volport_footer_bg_color') : '';
    $footer_bg_color = get_theme_mod('volport_footer_bg_color');

    $footer_style_2_switch = get_theme_mod('footer_style_2_switch');

    // footer logo from page
    $volport_footer_logo_from_page = !empty($volport_footer_page_logo['url']) ? $volport_footer_page_logo['url'] : $volport_footer_logo;  
    
    // bg image
    $bg_img = !empty($volport_footer_bg_url_from_page['url']) ? $volport_footer_bg_url_from_page['url'] : $footer_bg_img;  
    // bg color
    $bg_color = !empty($volport_footer_bg_color_from_page) ? $volport_footer_bg_color_from_page : $footer_bg_color;  

    $footer_columns = 0;
    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for( $num=1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-'. $num ) ){
            $footer_columns++;
        }
    }



    switch ( $footer_columns ) {
        case '1':
        $footer_class[1] = 'col-lg-12';
        break;
        case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
        case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;        
        case '4':
        $footer_class[1] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[4] = 'col-xl-3 col-lg-6 col-md-6';
        break;
        default:
        $footer_class = 'col-xl-3 col-lg-6 col-md-6';
        break;
    }    
?>
 
    <footer>
        <?php if ( is_active_sidebar('footer-1') OR is_active_sidebar('footer-2') OR is_active_sidebar('footer-3') OR is_active_sidebar('footer-4') ): ?>
        <section class="footer__area pt-100 pb-40 footer-bg" data-top-space="<?php print esc_attr($volport_footer_top_space); ?>px" data-bg-color="<?php print esc_attr($bg_color); ?>" data-background="<?php print esc_url($bg_img); ?>">
            <div class="container">
                <div class="row">
                    <?php
                    if ( $footer_columns < 4 ) {     
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-1');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-2');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3');
                        print '</div>'; 

                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-4');
                        print '</div>';       
                    }
                    else{
                            for( $num=1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-'. $num ) ) continue;
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-'. $num );
                                print '</div>';
                            }  
                        }
                    ?>
                </div>
            </div>
        </section>
        <?php endif; ?>
        <div class="copyright__area copyright-bg pt-35">
            <div class="container">
                <div class="row">
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="copyright__text mb-35">
                            <p><?php print volport_copyright_text(); ?></p>
                        </div>
                    </div>
                    <?php if(!empty($volport_footer_logo_from_page)) : ?>
                    <div class="col-xl-4 d-none d-xl-block">
                        <div class="copyright__logo p-relative">
                            <a href="<?php print esc_url(home_url('/')); ?>"><img src="<?php print esc_url($volport_footer_logo_from_page); ?>" alt="<?php bloginfo( 'name' ); ?>"></a>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty($footer_menu_switch)) : ?>
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <ul class="copyright__tos mb-30 text-md-end">
                            <li><a href="#"><?php echo esc_html__( 'Terms & Conditions', 'volport' ); ?></a></li>
                            <li><a href="#"><?php echo esc_html__( 'Careers', 'volport' ); ?></a></li>
                            <li><a href="#"><?php echo esc_html__( 'Get A Quote', 'volport' ); ?></a></li>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </footer>


<?php 
}
/**
* footer  style 2
*/
function volport_footer_style_2() {
    $footer_menu_switch = get_theme_mod('footer_menu_switch', false);

    $footer_bg_img = get_theme_mod('volport_footer_bg');
    $volport_footer_logo = get_theme_mod('volport_footer_logo');
    $volport_footer_page_logo = function_exists('get_field') ? get_field('volport_footer_page_logo') : '';
    $volport_footer_social = get_theme_mod('volport_footer_social');
    $volport_footer_top_space = function_exists('get_field') ? get_field('volport_footer_top_space') : '0';
    $volport_copyright_center = $volport_footer_social ? 'col-md-7' : 'col-lg-12 pt-20 pb-20 text-center';
    $volport_footer_bg_url_from_page = function_exists('get_field') ? get_field('volport_footer_bg') : '';
    $volport_footer_bg_color_from_page = function_exists('get_field') ? get_field('volport_footer_bg_color') : '';


    $footer_bg_color = get_theme_mod('volport_footer_bg_color');
    
    // footer logo from page
    $volport_footer_logo_from_page = !empty($volport_footer_page_logo['url']) ? $volport_footer_page_logo['url'] : $volport_footer_logo;  

    // bg image
    $bg_img = !empty($volport_footer_bg_url_from_page['url']) ? $volport_footer_bg_url_from_page['url'] : $footer_bg_img;  

    // bg color
    $bg_color = !empty($volport_footer_bg_color_from_page) ? $volport_footer_bg_color_from_page : $footer_bg_color;   

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for( $num=1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-2-'. $num ) ){
            $footer_columns++;
        }
    } 

    switch ( $footer_columns ) {
        case '1':
        $footer_class[1] = 'col-lg-12';
        break;
        case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
        case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;        
        case '4':
        $footer_class[1] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[4] = 'col-xl-3 col-lg-6 col-md-6';
        break;
        default:
        $footer_class = 'ccol-xl-3 col-lg-6 col-md-6';
        break;
    }  

?>
    <!-- footer area start here -->
    <footer>
        <?php if ( is_active_sidebar('footer-2-1') OR is_active_sidebar('footer-2-2') OR is_active_sidebar('footer-2-3') OR is_active_sidebar('footer-2-4') ): ?>
        <section class="footer__area pt-100 pb-70 footer-bg" data-top-space="<?php print esc_attr($volport_footer_top_space); ?>px" data-bg-color="<?php print esc_attr($bg_color); ?>" data-background="<?php print esc_url($bg_img); ?>">
            <div class="container">
                <div class="row">
                    <?php
                    if ( $footer_columns < 4 ) {     
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-2-1');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-2-2');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-2-3');
                        print '</div>'; 

                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-2-4');
                        print '</div>';       
                    }
                    else{
                            for( $num=1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-2-'. $num ) ) continue;
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-2-'. $num );
                                print '</div>';
                            }  
                        }
                    ?>
                </div>
            </div>
        </section>
        <?php endif; ?>
        <div class="copyright__area copyright-bg pt-35">
            <div class="container">
                <div class="row">
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="copyright__text mb-35">
                            <p><?php print volport_copyright_text(); ?></p>
                        </div>
                    </div>
                    <?php if(!empty($volport_footer_logo_from_page)) : ?>
                    <div class="col-xl-4 d-none d-xl-block">
                        <div class="copyright__logo p-relative">
                            <a href="<?php print esc_url(home_url('/')); ?>"><img src="<?php print esc_url($volport_footer_logo_from_page); ?>" alt="<?php bloginfo( 'name' ); ?>"></a>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty($footer_menu_switch)) : ?>
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <ul class="copyright__tos mb-30 text-md-end">
                            <li><a href="#"><?php echo esc_html__( 'Terms & Conditions', 'volport' ); ?></a></li>
                            <li><a href="#"><?php echo esc_html__( 'Careers', 'volport' ); ?></a></li>
                            <li><a href="#"><?php echo esc_html__( 'Get A Quote', 'volport' ); ?></a></li>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </footer>

<?php 
}

// footer style 03
function volport_footer_style_3() {
    $footer_menu_switch = get_theme_mod('footer_menu_switch', false);

    $footer_bg_img = get_theme_mod('volport_footer_bg');
    $volport_footer_logo = get_theme_mod('volport_footer_logo');
    $volport_footer_page_logo = function_exists('get_field') ? get_field('volport_footer_page_logo') : '';
    $volport_footer_social = get_theme_mod('volport_footer_social');
    $volport_footer_top_space = function_exists('get_field') ? get_field('volport_footer_top_space') : '0';
    $volport_copyright_center = $volport_footer_social ? 'col-md-7' : 'col-lg-12 pt-20 pb-20 text-center';
    $volport_footer_bg_url_from_page = function_exists('get_field') ? get_field('volport_footer_bg') : '';
    $volport_footer_bg_color_from_page = function_exists('get_field') ? get_field('volport_footer_bg_color') : '';


    $footer_bg_color = get_theme_mod('volport_footer_bg_color');
    
    // footer logo from page
    $volport_footer_logo_from_page = !empty($volport_footer_page_logo['url']) ? $volport_footer_page_logo['url'] : $volport_footer_logo;  

    // bg image
    $bg_img = !empty($volport_footer_bg_url_from_page['url']) ? $volport_footer_bg_url_from_page['url'] : $footer_bg_img;  

    // bg color
    $bg_color = !empty($volport_footer_bg_color_from_page) ? $volport_footer_bg_color_from_page : $footer_bg_color;   

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for( $num=1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-3-'. $num ) ){
            $footer_columns++;
        }
    } 

    switch ( $footer_columns ) {
        case '1':
        $footer_class[1] = 'col-lg-12';
        break;
        case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
        case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;        
        case '4':
        $footer_class[1] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-3 col-lg-6 col-md-6';
        $footer_class[4] = 'col-xl-3 col-lg-6 col-md-6';
        break;
        default:
        $footer_class = 'ccol-xl-3 col-lg-6 col-md-6';
        break;
    }  

?>
    <!-- footer area start here -->
    <footer>
        <?php if ( is_active_sidebar('footer-3-1') OR is_active_sidebar('footer-3-2') OR is_active_sidebar('footer-3-3') OR is_active_sidebar('footer-3-4') ): ?>
        <section class="footer__area pt-100 pb-70 grey-light-bg" data-top-space="<?php print esc_attr($volport_footer_top_space); ?>px" data-bg-color="<?php print esc_attr($bg_color); ?>" data-background="<?php print esc_url($bg_img); ?>">
            <div class="container">
                <div class="row">
                    <?php
                    if ( $footer_columns < 4 ) {     
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-1');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-2');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-3');
                        print '</div>'; 

                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-4');
                        print '</div>';       
                    }
                    else{
                            for( $num=1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-3-'. $num ) ) continue;
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-3-'. $num );
                                print '</div>';
                            }  
                        }
                    ?>
                </div>
            </div>
        </section>
        <?php endif; ?>
        <div class="copyright__area blue-bg pt-35">
            <div class="container">
                <div class="row">
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="copyright__text mb-35 c2">
                            <p><?php print volport_copyright_text(); ?></p>
                        </div>
                    </div>
                    <?php if(!empty($volport_footer_logo_from_page)) : ?>
                    <div class="col-xl-4 d-none d-xl-block">
                        <div class="copyright__logo p-relative c2">
                            <a href="<?php print esc_url(home_url('/')); ?>"><img src="<?php print esc_url($volport_footer_logo_from_page); ?>" alt="<?php bloginfo( 'name' ); ?>"></a>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty($footer_menu_switch)) : ?>
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <ul class="copyright__tos mb-30 text-md-end c2">
                            <li><a href="#"><?php echo esc_html__( 'Terms & Conditions', 'volport' ); ?></a></li>
                            <li><a href="#"><?php echo esc_html__( 'Careers', 'volport' ); ?></a></li>
                            <li><a href="#"><?php echo esc_html__( 'Get A Quote', 'volport' ); ?></a></li>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </footer>

<?php 
}


// footer style 04
function volport_footer_style_4() {
    $footer_menu_switch = get_theme_mod('footer_menu_switch', false);

    $footer_bg_img = get_theme_mod('volport_footer_bg');
    $volport_footer_logo = get_theme_mod('volport_footer_logo');
    $volport_footer_page_logo = function_exists('get_field') ? get_field('volport_footer_page_logo') : '';
    $volport_footer_social = get_theme_mod('volport_footer_social');
    $volport_footer_top_space = function_exists('get_field') ? get_field('volport_footer_top_space') : '0';
    $volport_copyright_center = $volport_footer_social ? 'col-md-7' : 'col-lg-12 pt-20 pb-20 text-center';
    $volport_footer_bg_url_from_page = function_exists('get_field') ? get_field('volport_footer_bg') : '';
    $volport_footer_bg_color_from_page = function_exists('get_field') ? get_field('volport_footer_bg_color') : '';


    $footer_bg_color = get_theme_mod('volport_footer_bg_color');
    
    // footer logo from page
    $volport_footer_logo_from_page = !empty($volport_footer_page_logo['url']) ? $volport_footer_page_logo['url'] : $volport_footer_logo;  
    
    // bg image
    $bg_img = !empty($volport_footer_bg_url_from_page['url']) ? $volport_footer_bg_url_from_page['url'] : $footer_bg_img;  

    // bg color
    $bg_color = !empty($volport_footer_bg_color_from_page) ? $volport_footer_bg_color_from_page : $footer_bg_color;   

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for( $num=1; $num <= $footer_widgets; $num++ ) {
        if ( is_active_sidebar( 'footer-4-'. $num ) ){
            $footer_columns++;
        }
    } 

    switch ( $footer_columns ) {
        case '1':
        $footer_class[1] = 'col-lg-12';
        break;
        case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
        case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-6';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;        
        case '4':
        $footer_class[1] = 'col-xl-2 col-lg-3 col-md-6';
        $footer_class[2] = 'col-xl-3 col-lg-4 col-md-6';
        $footer_class[3] = 'col-xl-4 col-lg-5 col-md-6';
        $footer_class[4] = 'col-xl-3 col-lg-12 col-md-6';
        break;
        default:
        $footer_class = 'ccol-xl-3 col-lg-6 col-md-6';
        break;
    }  

?>
    <!-- footer area start here -->
    <footer>
        <?php if ( is_active_sidebar('footer-4-1') OR is_active_sidebar('footer-4-2') OR is_active_sidebar('footer-4-3') OR is_active_sidebar('footer-4-4') ): ?>
        <section class="footer__area pt-100 pb-50 footer-bg2" data-top-space="<?php print esc_attr($volport_footer_top_space); ?>px" data-bg-color="<?php print esc_attr($bg_color); ?>" data-background="<?php print esc_url($bg_img); ?>">
            <div class="container ph-75">
                <div class="row">
                    <?php
                    if ( $footer_columns < 4 ) {     
                        print '<div class="col-xl-2 col-lg-3 col-md-6">';
                        dynamic_sidebar( 'footer-4-1');
                        print '</div>';
                    
                        print '<div class="col-xl-3 col-lg-4 col-md-6">';
                        dynamic_sidebar( 'footer-4-2');
                        print '</div>';
                    
                        print '<div class="col-xl-4 col-lg-5 col-md-6">';
                        dynamic_sidebar( 'footer-4-3');
                        print '</div>'; 

                        print '<div class="col-xl-3 col-lg-12 col-md-6">';
                        dynamic_sidebar( 'footer-4-4');
                        print '</div>';       
                    }
                    else{
                            for( $num=1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-4-'. $num ) ) continue;
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-4-'. $num );
                                print '</div>';
                            }  
                        }
                    ?>
                </div>
            </div>
        </section>
        <?php endif; ?>
        <div class="copyright__area copyright-bg2 pt-35">
            <div class="container ph-75">
                <div class="row">
                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                        <div class="copyright__text mb-35 c3">
                            <p><?php print volport_copyright_text(); ?></p>
                        </div>
                    </div>
                    <?php if(!empty($volport_footer_logo_from_page)) : ?>
                    <div class="col-xl-4 d-none d-xl-block">
                        <div class="copyright__logo p-relative c3">
                            <a href="<?php print esc_url(home_url('/')); ?>"><img src="<?php print esc_url($volport_footer_logo_from_page); ?>" alt="<?php bloginfo( 'name' ); ?>"></a>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty($footer_menu_switch)) : ?>
                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                        <div class="fs-position">
                            <ul class="copyright__social">
                                <?php volport_footer_social_profiles(); ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </footer>

<?php 
}

// volport_copyright_text
function volport_copyright_text(){
    if( rtl_enable() ){
        print get_theme_mod('volport_copyright_rtl', __('Copyright ©2022 Theme_Pure. All Rights Reserved','volport'));
    }
    else{
       print get_theme_mod('volport_copyright', __('Copyright ©2022 Theme_Pure. All Rights Reserved','volport'));
    }
}


/** 
 * [volport_breadcrumb_func description]
 * @return [type] [description]
 */
function volport_breadcrumb_func() { 

    
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    if (is_front_page() && is_home()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'zibber'));
        $breadcrumb_class = 'home_front_page';
    } elseif (is_front_page()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'zibber'));
        $breadcrumb_show = 0;
    } elseif (is_home()) {
        if (get_option('page_for_posts')) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    } elseif (is_single() && 'post' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'product' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'bdevs-services' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'bdevs-doctor' == get_post_type()) {
        $title = get_theme_mod('breadcrumb_doctor_details', __('Doctor Details', 'zibber'));
    } elseif (is_single() && 'bdevs-cases' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_search()) {
        $title = esc_html__('Search Results for : ', 'zibber') . get_search_query();
    } elseif (is_404()) {
        $title = esc_html__('Page not Found', 'zibber');
    } elseif (function_exists('is_woocommerce') && is_woocommerce()) {
        $title = get_theme_mod('breadcrumb_shop', __('Shop', 'zibber'));
    } elseif (is_archive()) {
        $title = get_the_archive_title();
    } else {
        $title = get_the_title();
    }

    $_id = get_the_ID();

    if (is_single() && 'product' == get_post_type()) {
        // $_id = $post->ID;
    } elseif (function_exists("is_shop") and is_shop()) {
        $_id = wc_get_page_id('shop');
    } elseif (is_home() && get_option('page_for_posts')) {
        $_id = get_option('page_for_posts');
    }

    $is_breadcrumb = function_exists('get_field') ? get_field('is_it_invisible_breadcrumb', $_id) : '';
    if (!empty($_GET['s'])) {
        $is_breadcrumb = null;
    }
    
    if( empty($is_breadcrumb) && $breadcrumb_show == 1 ) { 

        $bg_img_from_page = function_exists('get_field') ? get_field('breadcrumb_background_image', $_id) : '';
        $hide_bg_img = function_exists('get_field') ? get_field('hide_breadcrumb_background_image', $_id) : '';
        $breadcrumb_subtitle = function_exists('get_field') ? get_field('breadcrumb_subtitle', $_id) : '';
        $breadcrumb_img_from_page = function_exists('get_field') ? get_field('breadcrumb_image', $_id) : '';
        
        //get_theme_mod
        $bg_img = get_theme_mod('breadcrumb_bg_img');

        if( $hide_bg_img ){
            $bg_img = '';
        }
        else {
          $bg_img = !empty($bg_img_from_page) ? $bg_img_from_page['url'] : $bg_img;  
        } ?>

        <?php    
        $breadcrumb_shape_switch = get_theme_mod('breadcrumb_shape_switch', true); 
        ?>
        
        <!-- page title start here -->

        <div class="page-title-area d-flex align-items-center p-relative <?php print esc_attr($breadcrumb_class); ?>" data-background="<?php print esc_attr($bg_img);?>">
            <nav class="breadcrumb-menu" aria-label="breadcrumb">
                <div class="breadcrumb">
                    <?php volport_breadcrumb_callback();?>
                </div>
            </nav>
            <div class="container">
                <div class="row align-items-center pt-60">
                    <div class="col-md-7">
                        <div class="page-title-content">
                            <p><?php print esc_html($breadcrumb_subtitle); ?></p>
                            <h1><?php echo wp_kses_post( $title );?></h1>
                        </div>
                    </div>

                    <?php if(!empty($breadcrumb_img_from_page['url'])) : ?>
                    <div class="col-md-5 wow slideInRight">
                        <div class="page-title-img f-right d-none d-sm-block">
                            <img src="<?php print esc_url($breadcrumb_img_from_page['url']);?>" alt="<?php bloginfo( 'name' ); ?>">
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- page title end here -->


        <?php 
    }
}
add_action('volport_before_main_content', 'volport_breadcrumb_func');


function volport_breadcrumb_callback() {
    $args = array(
        'show_browse'   => false,
        'post_taxonomy' => array( 'product' =>'product_cat' )
    );
    $breadcrumb = new Breadcrumb_Class( $args );
    
    return $breadcrumb->trail();
}


// gru_search_form
function volport_search_form() { ?>
        <!-- Modal Search -->
        <div class="search-wrap">
            <div class="search-inner">
                <i class="fal fa-times search-close" id="search-close"></i>
                <div class="search-cell">
                    <form method="get" action="<?php print esc_url(home_url('/')); ?>" >
                        <div class="search-field-holder">
                            <input type="search" name="s" class="main-search-input" value="<?php print esc_attr( get_search_query() ) ?>" placeholder="<?php print esc_attr__('Search Your Keyword...', 'volport'); ?>">
                        </div>
                    </form>
                </div>
            </div>
        </div>

    <?php 
}

add_action('volport_before_main_content', 'volport_search_form');

/**
*
* pagination
*/
if( !function_exists('volport_pagination') ) {

    function _volport_pagi_callback($pagination) {
        return $pagination;
    }

    //page navegation
    function volport_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
        
        if( $pages=='' ){
            global $wp_query;
            $pages = $wp_query->max_num_pages;
            
            if(!$pages)
                $pages = 1;
        }

        $pagination = array(
            'base' => add_query_arg('paged','%#%'),
            'format' => '',
            'total' => $pages,
            'current' => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type' => 'array'
        );

        //rewrite permalinks
        if( $wp_rewrite->using_permalinks() )
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );

        if( !empty($wp_query->query_vars['s']) )
            $pagination['add_args'] = array( 's' => get_query_var( 's' ) );

        $pagi = '';
        if(paginate_links( $pagination )!=''){
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul>';
                        foreach ($paginations as $key => $pg) {
                            $pagi.= '<li>'.$pg.'</li>';
                        }
            $pagi .= '</ul>';
        }

        print _volport_pagi_callback($pagi);
    }
}

// rtl_enable
function rtl_enable(){
    $my_current_lang = apply_filters( 'wpml_current_language', NULL );
    $rtl_enable =get_theme_mod( 'rtl_switch',false);
    if ( $my_current_lang  != 'en' && $rtl_enable ) {
        return true;
    }
    else {
        return false;
    }
}

// header top bg color
function volport_breadcrumb_bg_color(){
    $color_code = get_theme_mod( 'volport_breadcrumb_bg_color','#222');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".breadcrumb-bg.gray-bg{ background: ".$color_code."}";

        wp_add_inline_style('volport-breadcrumb-bg',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'volport_breadcrumb_bg_color');

// breadcrumb-spacing top
function volport_breadcrumb_spacing(){
    $padding_px = get_theme_mod( 'volport_breadcrumb_spacing','160px');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($padding_px!=''){
        $custom_css = '';
        $custom_css .= ".breadcrumb-spacing{ padding-top: ".$padding_px."}";

        wp_add_inline_style('volport-breadcrumb-top-spacing',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'volport_breadcrumb_spacing');

// breadcrumb-spacing bottom
function volport_breadcrumb_bottom_spacing(){
    $padding_px = get_theme_mod( 'volport_breadcrumb_bottom_spacing','160px');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($padding_px!=''){
        $custom_css = '';
        $custom_css .= ".breadcrumb-spacing{ padding-bottom: ".$padding_px."}";

        wp_add_inline_style('volport-breadcrumb-bottom-spacing',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'volport_breadcrumb_bottom_spacing');


// scrollup
function volport_scrollup_switch(){
    $scrollup_switch = get_theme_mod( 'volport_scrollup_switch', false);
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($scrollup_switch){
        $custom_css = '';
        $custom_css .= "#scrollUp{ display: none !important;}";

        wp_add_inline_style('volport-scrollup-switch',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'volport_scrollup_switch');


// Theme color
function volport_custom_color(){
    $color_code = get_theme_mod( 'volport_color_option','#ff5e14');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".v-btn, .link-btn::before, .link-btn:hover::before, .footer__social li a:hover, .delivered, .form__quote .q-text::after, .order__form .nav-link.active, .request-quote, .sd-form button, .project__slider-2 .owl-nav .owl-arrow:hover, .project__img::before, .testimonial__active .slick-dots .slick-active button, .blog__date, .footer__widget-title::after, .footer__widget.widget_nav_menu ul li a:hover::before, .header__cta .cta__content ul li .support-img::before, .transport span, .s-btn.circle.black:hover::before, .features-box-single:hover, .features-box-icon, .blog__post.b-3 .blog__date, .widget-form button, .sd-content a.sd-icon:hover, .team-member-social li a:hover, .tmd-img::before, .member-skill .progress-bar, .project-menu button.active, .project__social li a:hover, .pd-slider .slick-dots .slick-active button, .faq-button:hover, .newsletter-area, .basic-pagination ul li .page-numbers:hover, .basic-pagination ul li .page-numbers.current, .n-sidebar-widget .sidebar-search-form button, .n-sidebar-widget.widget_tag_cloud .tag-cloud-link:hover, blockquote cite::before, div.blog__tag a:hover, .post-comment, .office-location .nav-link:hover, .object { background: ".$color_code."}";

        $custom_css .= ".main-menu-2 ul li .submenu li a:hover, .side-info-close:hover, .services__icon-3 i, .services__title-3 a:hover, .section-pre-title, .founder span, .founder h6 a:hover, .order__form-button i, .circle-chart-text .miles span, .features__icon i, .support__icon i, .support__about span, .project-search:hover, .testimonial__content .star.st-red li i, .testimonial__author-about span, .testimonial__author-about h4 a:hover, .project__img-content-inner h4 a:hover, .blog__content span, .blog__content .n_title a:hover, .blog__content > a:hover, .mail-address button, .footer__widget ul li a:hover, .footer__list-contact li i, .copyright__tos li a:hover, .header__login-title i, .header__login-title h5 a:hover, .header__login-social li a i:hover, .color-header.c3 .main-menu nav > ul > li:hover > a, .main-menu ul li .submenu li:hover > a, .service-list li:hover, .team__member-single h4 a:hover, .featured-author-social li a:hover, .news__content h4 a:hover, .news__content > span a:hover, .trail-item.trail-end, .section-title span.category, .features-box-single:hover .features-box-icon i, .main-menu ul li:hover > a, .main-menu ul li a:hover, .blog__post.b-3 .blog__content h4 a:hover, .widget-services li i, .widget-services li a:hover, .widget-services li a:hover, .widget-services li i, .sidebar-contact span, .sd-play, .team-member-single:hover .tc i, .team-member-content h4 a:hover, .team-member-content span, .approch__text ul li:hover i, .go-icon, .mission__text .dot-inner .dot-contact i, .dot-inner .dot-contact.clr li a:hover, .circle-chart-text .percentage span, .skill-items .center-arrow, .about-member-details > span, .member-qualification h4 span, .skill-title span, .project-menu button:hover, .faq-accordion .accordion-button::after, .faq-button i, .newsletter-icon i, .blog__meta span i, .n-blog__content .n-blog-title a:hover, .blog__meta span a:hover, .rc-post .rc-text a:hover, .news-sidebar .n-sidebar-widget ul li a:hover, .n-sidebar-widget li a::before, blockquote::before, blockquote cite::before, .logged-in-as a:hover, .logged-in-as a:hover, .office-address-icon i { color: ".$color_code."}";

        $custom_css .= ".main-menu ul li .submenu, .services__item-3:hover .services__inner-3, .testimonial__author-img, .color-header.c3 .main-menu ul li .submenu, .single-skill:hover, .project__social li a:hover, .faq-button:hover { border-color: ".$color_code."}";

        $custom_css .= ".circle-chart__circle { stroke: ".$color_code."}";
        $custom_css .= ".project__content-title .stroke-text { -webkit-text-stroke-color: ".$color_code."}";



        $custom_css .= ".aservice-box::after { border-color: ".$color_code." transparent transparent transparent}";
        wp_add_inline_style('volport-custom',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'volport_custom_color');

// Prymary color
function volport_primary_color(){
    $color_code = get_theme_mod( 'volport_primary_color','#1f61a7');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".v-btn-big, .portfolio__active .slick-dots .slick-active button, .testimonial-box__active .slick-dots .slick-active button { background: ".$color_code."}";

        $custom_css .= ".section-title span, .services__title-4 a:hover, .v-faq-content i, .dot-inner .dot-contact li i, .dot-inner .dot-contact li a:hover, .testimonial__content.testimonial-box .testimonial__author-about h4 a:hover, .testimonial__content.testimonial-box .testimonial__author-about span, .blog__tag-2 a, .blog__title-2 a:hover, .footer__address-2 i, .footer__address-2 i { color: ".$color_code."}";

        $custom_css .= ".testimonial__author-img-2 { border-color: ".$color_code."}";

        $custom_css .= ".ddd { border-color: transparent transparent ".$color_code." transparent;}";
        wp_add_inline_style('volport-custom',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'volport_primary_color');

// Secondary color
function volport_secondary_color(){
    $color_code = get_theme_mod( 'volport_secondary_color','#f02830');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".header__login-number, .hero__icon, .services__box-link a:hover, .g-hover-icon, .trending-plan, .service-btn.shutter-btn::before, .circle-more a:hover { background: ".$color_code."}";

        $custom_css .= ".hero__content h1 span span, .hero__content ul li i, .features__author-text span, .features__right-content li i, .services__box-content i, .services__box-list ul li i, .about__experience i, .service-price span, .about-circle .skill-circle .circle-chart-text .percentage span, a.v-btn-2 { color: ".$color_code."}";

        $custom_css .= ".about-circle .skill-circle .success-stroke { stroke: ".$color_code."}";

        $custom_css .= ".circle-more { border-color: ".$color_code."}";
        wp_add_inline_style('volport-custom',$custom_css);

    }
}
add_action('wp_enqueue_scripts', 'volport_secondary_color');

// Theme color 2 color
function volport_theme_color2(){
    $color_code = get_theme_mod( 'volport_theme_color2','#286bb2');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".v-faq .nav-tabs .nav-link.active, .portfolio__content a, .footer__widget.grey-light .footer__widget-title::after, .footer__widget.grey-light.widget_nav_menu ul li a:hover::before, .footer__widget.grey-light .footer__social li a:hover, .cta__box-inner::before, .cta__form ul li button, button.subscribe { background: ".$color_code."}";

        $custom_css .= ".portfolio__content span, .portfolio__content ul li i, .footer__widget.grey-light.widget_nav_menu ul li a:hover, .footer__list-contact.c-2 li i, .testimonial__content .star li i { color: ".$color_code."}";


        $custom_css .= ".ddd { border-color: ".$color_code."}";
        wp_add_inline_style('volport-custom',$custom_css);

    }
}

add_action('wp_enqueue_scripts', 'volport_theme_color2');


// Theme color 3 color
function volport_theme_color3(){
    $color_code = get_theme_mod( 'volport_theme_color3','#3a78ba');
    wp_enqueue_style( 'volport-custom', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".header__action-location .location-btn, .cta__form ul li button, button.subscribe, .copyright__logo.c2 a { background: ".$color_code."}";

        $custom_css .= ".ddd { color: ".$color_code."}";


        $custom_css .= ".ddd { border-color: ".$color_code."}";
        wp_add_inline_style('volport-custom',$custom_css);

    }
}

add_action('wp_enqueue_scripts', 'volport_theme_color3');


// Header 3 menu color
function volport_header_menu_color(){
    $color_code = get_theme_mod( 'volport_header_menu_color','#777777');
    wp_enqueue_style( 'volport-customs', VOLPORT_THEME_CSS_DIR . 'volport-custom.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".ddd { background: ".$color_code."}";

        $custom_css .= ".color-header.c2 .main-menu ul li .submenu li:hover > a:hover { color: ".$color_code."}";


        $custom_css .= ".color-header .main-menu ul li .submenu  { border-color: ".$color_code."}";
        wp_add_inline_style('volport-customs',$custom_css);

    }
}

add_action('wp_enqueue_scripts', 'volport_header_menu_color');


// volport_kses_intermediate
function volport_kses_intermediate( $string = '' ) {
    return wp_kses( $string, volport_get_allowed_html_tags( 'intermediate' ) );
}

function volport_get_allowed_html_tags( $level = 'basic' ) {
    $allowed_html = [
        'b' => [],
        'i' => [],
        'u' => [],
        'em' => [],
        'br' => [],
        'abbr' => [
            'title' => [],
        ],
        'span' => [
            'class' => [],
        ],
        'strong' => [],
        'a' => [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => []
        ]
    ];

    return $allowed_html;
}