<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package volport
 */

$gallery_images =  function_exists('acf_photo_gallery') ? acf_photo_gallery('gallery_images', get_the_id()) : ''; 

if( is_single() ): ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('n-blog__single mb-75 format-gallery'); ?>>
        <?php if (!empty($gallery_images)) : ?>
            <div class="n-blog__img">
                <div class="post-gallery-active swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach( $gallery_images as $key => $image ) :  ?>
                        <div class="ablog__img--item swiper-slide">
                            <img src="<?php echo  esc_url($image['full_image_url']); ?>" alt="<?php the_title(); ?>">
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <!-- If we need navigation buttons -->
                    <div class="swiper-button-prev slide-prev"><i class="far fa-chevron-left"></i></div>
                    <div class="swiper-button-next slide-next"><i class="far fa-chevron-right"></i></div>
                </div>
            </div>
        <?php endif; ?>

        <div class="n-blog__content p-relative">
            <div class="blog__meta mb-20">
                <span><i class="far fa-calendar-check"></i> <?php the_time( get_option('date_format') ); ?> </span>
                <span><a href="<?php print esc_url( get_author_posts_url( get_the_author_meta('ID') ) ); ?>"><i class="far fa-user"></i> <?php print get_the_author(); ?></a></span>
                <span><a href="<?php comments_link(); ?>"><i class="far fa-comments"></i> <?php comments_number(); ?></a></span>
            </div>
            <h4 class="n-blog-title">
                <?php the_title(); ?>
            </h4>

            <div class="post-text mb-30">
               <?php the_content(); ?>
                <?php
                    wp_link_pages( array(
                        'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'volport' ),
                        'after'       => '</div>',
                        'link_before' => '<span class="page-number">',
                        'link_after'  => '</span>',
                    ) );
                ?>
            </div>
            <div class="blog__deatails--tag">
                <?php print volport_get_tag(); ?>
            </div>
        </div>
    </article><?php
else: ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('n-blog__single mb-40 format-gallery'); ?>>
        <?php if (!empty($gallery_images)) : ?>
            <div class="n-blog__img">
                <div class="post-gallery-active swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach( $gallery_images as $key => $image ) :  ?>
                        <div class="ablog__img--item swiper-slide">
                            <img src="<?php echo  esc_url($image['full_image_url']); ?>" alt="<?php the_title(); ?>">
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <!-- If we need navigation buttons -->
                    <div class="swiper-button-prev slide-prev"><i class="far fa-chevron-left"></i></div>
                    <div class="swiper-button-next slide-next"><i class="far fa-chevron-right"></i></div>
                </div>
            </div>
        <?php endif; ?>
        <div class="n-blog__content p-relative">
            <div class="blog__meta mb-20">
                <span><i class="far fa-calendar-check"></i> <?php the_time( get_option('date_format') ); ?> </span>
                <span><a href="<?php print esc_url( get_author_posts_url( get_the_author_meta('ID') ) ); ?>"><i class="far fa-user"></i> <?php print get_the_author(); ?></a></span>
                <span><a href="<?php comments_link(); ?>"><i class="far fa-comments"></i> <?php comments_number(); ?></a></span>
            </div>
            <h4 class="n-blog-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
            <div class="post-text mb-30">
                <?php the_excerpt(); ?>
            </div>
            <!-- blog btn -->

            <?php 

                $volport_blog_btn_switch     = get_theme_mod('volport_blog_btn_switch', true);  
            ?>
            <?php if(!empty($volport_blog_btn_switch)) : ?>
                <div class="blog_btn">
                    <a href="<?php the_permalink(); ?>" class="v-btn">
                        <?php print esc_html__( 'Read More', 'volport' ); ?> <i class="fal fa-arrow-alt-right"></i>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </article>


<?php
endif; ?>


